// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.DomainConfigurationSummary
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ListDomainConfigurationsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListDomainConfigurationsOperationDeserializer: HttpDeserialize<ListDomainConfigurationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDomainConfigurationsResponse {
        if (!response.status.isSuccess()) {
            throwListDomainConfigurationsError(context, response)
        }
        val builder = ListDomainConfigurationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDomainConfigurationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListDomainConfigurationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDomainConfigurationsOperationBody(builder: ListDomainConfigurationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("domainConfigurations"))
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextMarker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINCONFIGURATIONS_DESCRIPTOR)
        field(NEXTMARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINCONFIGURATIONS_DESCRIPTOR.index -> builder.domainConfigurations =
                    deserializer.deserializeList(DOMAINCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DomainConfigurationSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDomainConfigurationSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
