// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.GetPackageConfigurationResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.VersionUpdateByJobsConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPackageConfigurationOperationDeserializer: HttpDeserialize<GetPackageConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPackageConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetPackageConfigurationError(context, response)
        }
        val builder = GetPackageConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPackageConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPackageConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPackageConfigurationOperationBody(builder: GetPackageConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VERSIONUPDATEBYJOBSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("versionUpdateByJobsConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VERSIONUPDATEBYJOBSCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VERSIONUPDATEBYJOBSCONFIG_DESCRIPTOR.index -> builder.versionUpdateByJobsConfig = deserializeVersionUpdateByJobsConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
