// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.CreatePackageResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePackageOperationDeserializer: HttpDeserialize<CreatePackageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePackageResponse {
        if (!response.status.isSuccess()) {
            throwCreatePackageError(context, response)
        }
        val builder = CreatePackageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePackageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreatePackageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePackageOperationBody(builder: CreatePackageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val PACKAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packageArn"))
    val PACKAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packageName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(PACKAGEARN_DESCRIPTOR)
        field(PACKAGENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                PACKAGEARN_DESCRIPTOR.index -> builder.packageArn = deserializeString()
                PACKAGENAME_DESCRIPTOR.index -> builder.packageName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
