// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ValidateSecurityProfileBehaviorsResponse
import aws.sdk.kotlin.services.iot.model.ValidationError
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ValidateSecurityProfileBehaviorsOperationDeserializer: HttpDeserialize<ValidateSecurityProfileBehaviorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ValidateSecurityProfileBehaviorsResponse {
        if (!response.status.isSuccess()) {
            throwValidateSecurityProfileBehaviorsError(context, response)
        }
        val builder = ValidateSecurityProfileBehaviorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeValidateSecurityProfileBehaviorsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwValidateSecurityProfileBehaviorsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateSecurityProfileBehaviorsOperationBody(builder: ValidateSecurityProfileBehaviorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("valid"))
    val VALIDATIONERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationErrors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VALID_DESCRIPTOR)
        field(VALIDATIONERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VALID_DESCRIPTOR.index -> builder.valid = deserializeBoolean()
                VALIDATIONERRORS_DESCRIPTOR.index -> builder.validationErrors =
                    deserializer.deserializeList(VALIDATIONERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidationError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidationErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
