// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AbortConfig
import aws.sdk.kotlin.services.iot.model.CreateJobRequest
import aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig
import aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig
import aws.sdk.kotlin.services.iot.model.PresignedUrlConfig
import aws.sdk.kotlin.services.iot.model.SchedulingConfig
import aws.sdk.kotlin.services.iot.model.Tag
import aws.sdk.kotlin.services.iot.model.TargetSelection
import aws.sdk.kotlin.services.iot.model.TimeoutConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateJobOperationSerializer: HttpSerialize<CreateJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "jobs",
                "${input.jobId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateJobOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateJobOperationBody(context: ExecutionContext, input: CreateJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ABORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("abortConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("document"))
    val DOCUMENTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("documentParameters"))
    val DOCUMENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("documentSource"))
    val JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRetryConfig"))
    val JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRolloutConfig"))
    val JOBTEMPLATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobTemplateArn"))
    val NAMESPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceId"))
    val PRESIGNEDURLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("presignedUrlConfig"))
    val SCHEDULINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("schedulingConfig"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TARGETSELECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("targetSelection"))
    val TARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targets"))
    val TIMEOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timeoutConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABORTCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOCUMENT_DESCRIPTOR)
        field(DOCUMENTPARAMETERS_DESCRIPTOR)
        field(DOCUMENTSOURCE_DESCRIPTOR)
        field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR)
        field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR)
        field(JOBTEMPLATEARN_DESCRIPTOR)
        field(NAMESPACEID_DESCRIPTOR)
        field(PRESIGNEDURLCONFIG_DESCRIPTOR)
        field(SCHEDULINGCONFIG_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETSELECTION_DESCRIPTOR)
        field(TARGETS_DESCRIPTOR)
        field(TIMEOUTCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.abortConfig?.let { field(ABORTCONFIG_DESCRIPTOR, it, ::serializeAbortConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.document?.let { field(DOCUMENT_DESCRIPTOR, it) }
        if (input.documentParameters != null) {
            mapField(DOCUMENTPARAMETERS_DESCRIPTOR) {
                input.documentParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.documentSource?.let { field(DOCUMENTSOURCE_DESCRIPTOR, it) }
        input.jobExecutionsRetryConfig?.let { field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR, it, ::serializeJobExecutionsRetryConfigDocument) }
        input.jobExecutionsRolloutConfig?.let { field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR, it, ::serializeJobExecutionsRolloutConfigDocument) }
        input.jobTemplateArn?.let { field(JOBTEMPLATEARN_DESCRIPTOR, it) }
        input.namespaceId?.let { field(NAMESPACEID_DESCRIPTOR, it) }
        input.presignedUrlConfig?.let { field(PRESIGNEDURLCONFIG_DESCRIPTOR, it, ::serializePresignedUrlConfigDocument) }
        input.schedulingConfig?.let { field(SCHEDULINGCONFIG_DESCRIPTOR, it, ::serializeSchedulingConfigDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.targetSelection?.let { field(TARGETSELECTION_DESCRIPTOR, it.value) }
        if (input.targets != null) {
            listField(TARGETS_DESCRIPTOR) {
                for (el0 in input.targets) {
                    serializeString(el0)
                }
            }
        }
        input.timeoutConfig?.let { field(TIMEOUTCONFIG_DESCRIPTOR, it, ::serializeTimeoutConfigDocument) }
    }
    return serializer.toByteArray()
}
