// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The input to the RegisterCACertificate operation.
 */
public class RegisterCaCertificateRequest private constructor(builder: Builder) {
    /**
     * Allows this CA certificate to be used for auto registration of device certificates.
     */
    public val allowAutoRegistration: kotlin.Boolean = builder.allowAutoRegistration
    /**
     * The CA certificate.
     */
    public val caCertificate: kotlin.String? = builder.caCertificate
    /**
     * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the `verificationCertificate` field is not provided, set `certificateMode` to be `SNI_ONLY`. If the `verificationCertificate` field is provided, set `certificateMode` to be `DEFAULT`. When `certificateMode` is not provided, it defaults to `DEFAULT`. All the device certificates that are registered using this CA will be registered in the same certificate mode as the CA. For more information about certificate mode for device certificates, see [ certificate mode](https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode).
     */
    public val certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = builder.certificateMode
    /**
     * Information about the registration configuration.
     */
    public val registrationConfig: aws.sdk.kotlin.services.iot.model.RegistrationConfig? = builder.registrationConfig
    /**
     * A boolean value that specifies if the CA certificate is set to active.
     *
     * Valid values: `ACTIVE | INACTIVE`
     */
    public val setAsActive: kotlin.Boolean = builder.setAsActive
    /**
     * Metadata which can be used to manage the CA certificate.
     *
     * For URI Request parameters use format: ...key1=value1&key2=value2...
     *
     * For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     *
     * For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The private key verification certificate. If `certificateMode` is `SNI_ONLY`, the `verificationCertificate` field must be empty. If `certificateMode` is `DEFAULT` or not provided, the `verificationCertificate` field must not be empty.
     */
    public val verificationCertificate: kotlin.String? = builder.verificationCertificate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterCaCertificateRequest(")
        append("allowAutoRegistration=$allowAutoRegistration,")
        append("caCertificate=$caCertificate,")
        append("certificateMode=$certificateMode,")
        append("registrationConfig=$registrationConfig,")
        append("setAsActive=$setAsActive,")
        append("tags=$tags,")
        append("verificationCertificate=$verificationCertificate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowAutoRegistration.hashCode()
        result = 31 * result + (caCertificate?.hashCode() ?: 0)
        result = 31 * result + (certificateMode?.hashCode() ?: 0)
        result = 31 * result + (registrationConfig?.hashCode() ?: 0)
        result = 31 * result + (setAsActive.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (verificationCertificate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterCaCertificateRequest

        if (allowAutoRegistration != other.allowAutoRegistration) return false
        if (caCertificate != other.caCertificate) return false
        if (certificateMode != other.certificateMode) return false
        if (registrationConfig != other.registrationConfig) return false
        if (setAsActive != other.setAsActive) return false
        if (tags != other.tags) return false
        if (verificationCertificate != other.verificationCertificate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Allows this CA certificate to be used for auto registration of device certificates.
         */
        public var allowAutoRegistration: kotlin.Boolean = false
        /**
         * The CA certificate.
         */
        public var caCertificate: kotlin.String? = null
        /**
         * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the `verificationCertificate` field is not provided, set `certificateMode` to be `SNI_ONLY`. If the `verificationCertificate` field is provided, set `certificateMode` to be `DEFAULT`. When `certificateMode` is not provided, it defaults to `DEFAULT`. All the device certificates that are registered using this CA will be registered in the same certificate mode as the CA. For more information about certificate mode for device certificates, see [ certificate mode](https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode).
         */
        public var certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = null
        /**
         * Information about the registration configuration.
         */
        public var registrationConfig: aws.sdk.kotlin.services.iot.model.RegistrationConfig? = null
        /**
         * A boolean value that specifies if the CA certificate is set to active.
         *
         * Valid values: `ACTIVE | INACTIVE`
         */
        public var setAsActive: kotlin.Boolean = false
        /**
         * Metadata which can be used to manage the CA certificate.
         *
         * For URI Request parameters use format: ...key1=value1&key2=value2...
         *
         * For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
         *
         * For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
         */
        public var tags: List<Tag>? = null
        /**
         * The private key verification certificate. If `certificateMode` is `SNI_ONLY`, the `verificationCertificate` field must be empty. If `certificateMode` is `DEFAULT` or not provided, the `verificationCertificate` field must not be empty.
         */
        public var verificationCertificate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest) : this() {
            this.allowAutoRegistration = x.allowAutoRegistration
            this.caCertificate = x.caCertificate
            this.certificateMode = x.certificateMode
            this.registrationConfig = x.registrationConfig
            this.setAsActive = x.setAsActive
            this.tags = x.tags
            this.verificationCertificate = x.verificationCertificate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest = RegisterCaCertificateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.RegistrationConfig] inside the given [block]
         */
        public fun registrationConfig(block: aws.sdk.kotlin.services.iot.model.RegistrationConfig.Builder.() -> kotlin.Unit) {
            this.registrationConfig = aws.sdk.kotlin.services.iot.model.RegistrationConfig.invoke(block)
        }
    }
}
