// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



public class ListJobsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return per request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     *
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
     *
     * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
     *
     * The `namespaceId` feature is in public preview.
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * The token to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An optional filter that lets you search for jobs that have the specified status.
     */
    public val status: aws.sdk.kotlin.services.iot.model.JobStatus? = builder.status
    /**
     * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.
     *
     * We recommend that you use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using continuous jobs, devices that join the group receive the job execution even after the job has been created.
     */
    public val targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = builder.targetSelection
    /**
     * A filter that limits the returned jobs to those for the specified group.
     */
    public val thingGroupId: kotlin.String? = builder.thingGroupId
    /**
     * A filter that limits the returned jobs to those for the specified group.
     */
    public val thingGroupName: kotlin.String? = builder.thingGroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ListJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListJobsRequest(")
        append("maxResults=$maxResults,")
        append("namespaceId=$namespaceId,")
        append("nextToken=$nextToken,")
        append("status=$status,")
        append("targetSelection=$targetSelection,")
        append("thingGroupId=$thingGroupId,")
        append("thingGroupName=$thingGroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetSelection?.hashCode() ?: 0)
        result = 31 * result + (thingGroupId?.hashCode() ?: 0)
        result = 31 * result + (thingGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListJobsRequest

        if (maxResults != other.maxResults) return false
        if (namespaceId != other.namespaceId) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false
        if (targetSelection != other.targetSelection) return false
        if (thingGroupId != other.thingGroupId) return false
        if (thingGroupName != other.thingGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ListJobsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return per request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         *
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
         *
         * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
         *
         * The `namespaceId` feature is in public preview.
         */
        public var namespaceId: kotlin.String? = null
        /**
         * The token to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An optional filter that lets you search for jobs that have the specified status.
         */
        public var status: aws.sdk.kotlin.services.iot.model.JobStatus? = null
        /**
         * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.
         *
         * We recommend that you use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using continuous jobs, devices that join the group receive the job execution even after the job has been created.
         */
        public var targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = null
        /**
         * A filter that limits the returned jobs to those for the specified group.
         */
        public var thingGroupId: kotlin.String? = null
        /**
         * A filter that limits the returned jobs to those for the specified group.
         */
        public var thingGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ListJobsRequest) : this() {
            this.maxResults = x.maxResults
            this.namespaceId = x.namespaceId
            this.nextToken = x.nextToken
            this.status = x.status
            this.targetSelection = x.targetSelection
            this.thingGroupId = x.thingGroupId
            this.thingGroupName = x.thingGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ListJobsRequest = ListJobsRequest(this)
    }
}
