// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The findings (results) of the audit.
 */
public class AuditFinding private constructor(builder: Builder) {
    /**
     * The audit check that generated this result.
     */
    public val checkName: kotlin.String? = builder.checkName
    /**
     * A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to one or more sets of findings.
     */
    public val findingId: kotlin.String? = builder.findingId
    /**
     * The time the result (finding) was discovered.
     */
    public val findingTime: aws.smithy.kotlin.runtime.time.Instant? = builder.findingTime
    /**
     * Indicates whether the audit finding was suppressed or not during reporting.
     */
    public val isSuppressed: kotlin.Boolean? = builder.isSuppressed
    /**
     * The resource that was found to be noncompliant with the audit check.
     */
    public val nonCompliantResource: aws.sdk.kotlin.services.iot.model.NonCompliantResource? = builder.nonCompliantResource
    /**
     * The reason the resource was noncompliant.
     */
    public val reasonForNonCompliance: kotlin.String? = builder.reasonForNonCompliance
    /**
     * A code that indicates the reason that the resource was noncompliant.
     */
    public val reasonForNonComplianceCode: kotlin.String? = builder.reasonForNonComplianceCode
    /**
     * The list of related resources.
     */
    public val relatedResources: List<RelatedResource>? = builder.relatedResources
    /**
     * The severity of the result (finding).
     */
    public val severity: aws.sdk.kotlin.services.iot.model.AuditFindingSeverity? = builder.severity
    /**
     * The ID of the audit that generated this result (finding).
     */
    public val taskId: kotlin.String? = builder.taskId
    /**
     * The time the audit started.
     */
    public val taskStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.taskStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AuditFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuditFinding(")
        append("checkName=$checkName,")
        append("findingId=$findingId,")
        append("findingTime=$findingTime,")
        append("isSuppressed=$isSuppressed,")
        append("nonCompliantResource=$nonCompliantResource,")
        append("reasonForNonCompliance=$reasonForNonCompliance,")
        append("reasonForNonComplianceCode=$reasonForNonComplianceCode,")
        append("relatedResources=$relatedResources,")
        append("severity=$severity,")
        append("taskId=$taskId,")
        append("taskStartTime=$taskStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkName?.hashCode() ?: 0
        result = 31 * result + (findingId?.hashCode() ?: 0)
        result = 31 * result + (findingTime?.hashCode() ?: 0)
        result = 31 * result + (isSuppressed?.hashCode() ?: 0)
        result = 31 * result + (nonCompliantResource?.hashCode() ?: 0)
        result = 31 * result + (reasonForNonCompliance?.hashCode() ?: 0)
        result = 31 * result + (reasonForNonComplianceCode?.hashCode() ?: 0)
        result = 31 * result + (relatedResources?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        result = 31 * result + (taskStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuditFinding

        if (checkName != other.checkName) return false
        if (findingId != other.findingId) return false
        if (findingTime != other.findingTime) return false
        if (isSuppressed != other.isSuppressed) return false
        if (nonCompliantResource != other.nonCompliantResource) return false
        if (reasonForNonCompliance != other.reasonForNonCompliance) return false
        if (reasonForNonComplianceCode != other.reasonForNonComplianceCode) return false
        if (relatedResources != other.relatedResources) return false
        if (severity != other.severity) return false
        if (taskId != other.taskId) return false
        if (taskStartTime != other.taskStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AuditFinding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The audit check that generated this result.
         */
        public var checkName: kotlin.String? = null
        /**
         * A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to one or more sets of findings.
         */
        public var findingId: kotlin.String? = null
        /**
         * The time the result (finding) was discovered.
         */
        public var findingTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the audit finding was suppressed or not during reporting.
         */
        public var isSuppressed: kotlin.Boolean? = null
        /**
         * The resource that was found to be noncompliant with the audit check.
         */
        public var nonCompliantResource: aws.sdk.kotlin.services.iot.model.NonCompliantResource? = null
        /**
         * The reason the resource was noncompliant.
         */
        public var reasonForNonCompliance: kotlin.String? = null
        /**
         * A code that indicates the reason that the resource was noncompliant.
         */
        public var reasonForNonComplianceCode: kotlin.String? = null
        /**
         * The list of related resources.
         */
        public var relatedResources: List<RelatedResource>? = null
        /**
         * The severity of the result (finding).
         */
        public var severity: aws.sdk.kotlin.services.iot.model.AuditFindingSeverity? = null
        /**
         * The ID of the audit that generated this result (finding).
         */
        public var taskId: kotlin.String? = null
        /**
         * The time the audit started.
         */
        public var taskStartTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AuditFinding) : this() {
            this.checkName = x.checkName
            this.findingId = x.findingId
            this.findingTime = x.findingTime
            this.isSuppressed = x.isSuppressed
            this.nonCompliantResource = x.nonCompliantResource
            this.reasonForNonCompliance = x.reasonForNonCompliance
            this.reasonForNonComplianceCode = x.reasonForNonComplianceCode
            this.relatedResources = x.relatedResources
            this.severity = x.severity
            this.taskId = x.taskId
            this.taskStartTime = x.taskStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AuditFinding = AuditFinding(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.NonCompliantResource] inside the given [block]
         */
        public fun nonCompliantResource(block: aws.sdk.kotlin.services.iot.model.NonCompliantResource.Builder.() -> kotlin.Unit) {
            this.nonCompliantResource = aws.sdk.kotlin.services.iot.model.NonCompliantResource.invoke(block)
        }
    }
}
