// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AuditFrequency
import aws.sdk.kotlin.services.iot.model.DayOfWeek
import aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeScheduledAuditOperationDeserializer: HttpDeserialize<DescribeScheduledAuditResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeScheduledAuditResponse {
        if (!response.status.isSuccess()) {
            throwDescribeScheduledAuditError(context, response)
        }
        val builder = DescribeScheduledAuditResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeScheduledAuditOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeScheduledAuditError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeScheduledAuditOperationBody(builder: DescribeScheduledAuditResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DAYOFMONTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dayOfMonth"))
    val DAYOFWEEK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dayOfWeek"))
    val FREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("frequency"))
    val SCHEDULEDAUDITARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scheduledAuditArn"))
    val SCHEDULEDAUDITNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scheduledAuditName"))
    val TARGETCHECKNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targetCheckNames"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DAYOFMONTH_DESCRIPTOR)
        field(DAYOFWEEK_DESCRIPTOR)
        field(FREQUENCY_DESCRIPTOR)
        field(SCHEDULEDAUDITARN_DESCRIPTOR)
        field(SCHEDULEDAUDITNAME_DESCRIPTOR)
        field(TARGETCHECKNAMES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DAYOFMONTH_DESCRIPTOR.index -> builder.dayOfMonth = deserializeString()
                DAYOFWEEK_DESCRIPTOR.index -> builder.dayOfWeek = deserializeString().let { DayOfWeek.fromValue(it) }
                FREQUENCY_DESCRIPTOR.index -> builder.frequency = deserializeString().let { AuditFrequency.fromValue(it) }
                SCHEDULEDAUDITARN_DESCRIPTOR.index -> builder.scheduledAuditArn = deserializeString()
                SCHEDULEDAUDITNAME_DESCRIPTOR.index -> builder.scheduledAuditName = deserializeString()
                TARGETCHECKNAMES_DESCRIPTOR.index -> builder.targetCheckNames =
                    deserializer.deserializeList(TARGETCHECKNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
