// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.CreateThingGroupResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateThingGroupOperationDeserializer: HttpDeserialize<CreateThingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateThingGroupResponse {
        if (!response.status.isSuccess()) {
            throwCreateThingGroupError(context, response)
        }
        val builder = CreateThingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateThingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateThingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateThingGroupOperationBody(builder: CreateThingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val THINGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupArn"))
    val THINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupId"))
    val THINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(THINGGROUPARN_DESCRIPTOR)
        field(THINGGROUPID_DESCRIPTOR)
        field(THINGGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                THINGGROUPARN_DESCRIPTOR.index -> builder.thingGroupArn = deserializeString()
                THINGGROUPID_DESCRIPTOR.index -> builder.thingGroupId = deserializeString()
                THINGGROUPNAME_DESCRIPTOR.index -> builder.thingGroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
