// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AuthorizerConfig
import aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest
import aws.sdk.kotlin.services.iot.model.ServiceType
import aws.sdk.kotlin.services.iot.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDomainConfigurationOperationSerializer: HttpSerialize<CreateDomainConfigurationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDomainConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "domainConfigurations",
                "${input.domainConfigurationName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateDomainConfigurationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDomainConfigurationOperationBody(context: ExecutionContext, input: CreateDomainConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHORIZERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorizerConfig"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainName"))
    val SERVERCERTIFICATEARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("serverCertificateArns"))
    val SERVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("serviceType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val VALIDATIONCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("validationCertificateArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZERCONFIG_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(SERVERCERTIFICATEARNS_DESCRIPTOR)
        field(SERVICETYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VALIDATIONCERTIFICATEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authorizerConfig?.let { field(AUTHORIZERCONFIG_DESCRIPTOR, it, ::serializeAuthorizerConfigDocument) }
        input.domainName?.let { field(DOMAINNAME_DESCRIPTOR, it) }
        if (input.serverCertificateArns != null) {
            listField(SERVERCERTIFICATEARNS_DESCRIPTOR) {
                for (el0 in input.serverCertificateArns) {
                    serializeString(el0)
                }
            }
        }
        input.serviceType?.let { field(SERVICETYPE_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.validationCertificateArn?.let { field(VALIDATIONCERTIFICATEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
