// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * A map of key-value pairs containing the patterns that need to be replaced in a managed template job document schema. You can use the description of each key as a guidance to specify the inputs during runtime when creating a job.
 *
 * `documentParameters` can only be used when creating jobs from Amazon Web Services managed templates. This parameter can't be used with custom job templates or to create jobs from them.
 */
public class DocumentParameter private constructor(builder: Builder) {
    /**
     * Description of the map field containing the patterns that need to be replaced in a managed template job document schema.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An example illustrating a pattern that need to be replaced in a managed template job document schema.
     */
    public val example: kotlin.String? = builder.example
    /**
     * Key of the map field containing the patterns that need to be replaced in a managed template job document schema.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Specifies whether a pattern that needs to be replaced in a managed template job document schema is optional or required.
     */
    public val optional: kotlin.Boolean = builder.optional
    /**
     * A regular expression of the patterns that need to be replaced in a managed template job document schema.
     */
    public val regex: kotlin.String? = builder.regex

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DocumentParameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentParameter(")
        append("description=$description,")
        append("example=$example,")
        append("key=$key,")
        append("optional=$optional,")
        append("regex=$regex")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (example?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (optional.hashCode())
        result = 31 * result + (regex?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentParameter

        if (description != other.description) return false
        if (example != other.example) return false
        if (key != other.key) return false
        if (optional != other.optional) return false
        if (regex != other.regex) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DocumentParameter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Description of the map field containing the patterns that need to be replaced in a managed template job document schema.
         */
        public var description: kotlin.String? = null
        /**
         * An example illustrating a pattern that need to be replaced in a managed template job document schema.
         */
        public var example: kotlin.String? = null
        /**
         * Key of the map field containing the patterns that need to be replaced in a managed template job document schema.
         */
        public var key: kotlin.String? = null
        /**
         * Specifies whether a pattern that needs to be replaced in a managed template job document schema is optional or required.
         */
        public var optional: kotlin.Boolean = false
        /**
         * A regular expression of the patterns that need to be replaced in a managed template job document schema.
         */
        public var regex: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DocumentParameter) : this() {
            this.description = x.description
            this.example = x.example
            this.key = x.key
            this.optional = x.optional
            this.regex = x.regex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DocumentParameter = DocumentParameter(this)
    }
}
