// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.HttpContext
import aws.sdk.kotlin.services.iot.model.MqttContext
import aws.sdk.kotlin.services.iot.model.TestInvokeAuthorizerRequest
import aws.sdk.kotlin.services.iot.model.TlsContext
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestInvokeAuthorizerOperationSerializer: HttpSerialize<TestInvokeAuthorizerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: TestInvokeAuthorizerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "authorizer",
                "${input.authorizerName}".encodeLabel(),
                "test",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeTestInvokeAuthorizerOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeTestInvokeAuthorizerOperationBody(context: ExecutionContext, input: TestInvokeAuthorizerRequest): ByteArray {
    val serializer = JsonSerializer()
    val HTTPCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("httpContext"))
    val MQTTCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mqttContext"))
    val TLSCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsContext"))
    val TOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("token"))
    val TOKENSIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenSignature"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HTTPCONTEXT_DESCRIPTOR)
        field(MQTTCONTEXT_DESCRIPTOR)
        field(TLSCONTEXT_DESCRIPTOR)
        field(TOKEN_DESCRIPTOR)
        field(TOKENSIGNATURE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.httpContext?.let { field(HTTPCONTEXT_DESCRIPTOR, it, ::serializeHttpContextDocument) }
        input.mqttContext?.let { field(MQTTCONTEXT_DESCRIPTOR, it, ::serializeMqttContextDocument) }
        input.tlsContext?.let { field(TLSCONTEXT_DESCRIPTOR, it, ::serializeTlsContextDocument) }
        input.token?.let { field(TOKEN_DESCRIPTOR, it) }
        input.tokenSignature?.let { field(TOKENSIGNATURE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
