// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.AggregationType
import aws.sdk.kotlin.services.iot.model.DescribeFleetMetricResponse
import aws.sdk.kotlin.services.iot.model.FleetMetricUnit
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeFleetMetricOperationDeserializer: HttpDeserialize<DescribeFleetMetricResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFleetMetricResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFleetMetricError(context, response)
        }
        val builder = DescribeFleetMetricResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFleetMetricOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFleetMetricError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFleetMetricOperationBody(builder: DescribeFleetMetricResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGGREGATIONFIELD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("aggregationField"))
    val AGGREGATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("aggregationType"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val METRICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("metricArn"))
    val METRICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("metricName"))
    val PERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("period"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val UNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("unit"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATIONFIELD_DESCRIPTOR)
        field(AGGREGATIONTYPE_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(METRICARN_DESCRIPTOR)
        field(METRICNAME_DESCRIPTOR)
        field(PERIOD_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(UNIT_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGGREGATIONFIELD_DESCRIPTOR.index -> builder.aggregationField = deserializeString()
                AGGREGATIONTYPE_DESCRIPTOR.index -> builder.aggregationType = deserializeAggregationTypeDocument(deserializer)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INDEXNAME_DESCRIPTOR.index -> builder.indexName = deserializeString()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                METRICARN_DESCRIPTOR.index -> builder.metricArn = deserializeString()
                METRICNAME_DESCRIPTOR.index -> builder.metricName = deserializeString()
                PERIOD_DESCRIPTOR.index -> builder.period = deserializeInt()
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                QUERYVERSION_DESCRIPTOR.index -> builder.queryVersion = deserializeString()
                UNIT_DESCRIPTOR.index -> builder.unit = deserializeString().let { FleetMetricUnit.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
