// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.AuditCheckDetails
import aws.sdk.kotlin.services.iot.model.AuditTaskStatus
import aws.sdk.kotlin.services.iot.model.AuditTaskType
import aws.sdk.kotlin.services.iot.model.DescribeAuditTaskResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.TaskStatistics
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class DescribeAuditTaskOperationDeserializer: HttpDeserialize<DescribeAuditTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAuditTaskResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAuditTaskError(context, response)
        }
        val builder = DescribeAuditTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAuditTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAuditTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAuditTaskOperationBody(builder: DescribeAuditTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDITDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("auditDetails"))
    val SCHEDULEDAUDITNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scheduledAuditName"))
    val TASKSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("taskStartTime"))
    val TASKSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("taskStatistics"))
    val TASKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("taskStatus"))
    val TASKTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("taskType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDITDETAILS_DESCRIPTOR)
        field(SCHEDULEDAUDITNAME_DESCRIPTOR)
        field(TASKSTARTTIME_DESCRIPTOR)
        field(TASKSTATISTICS_DESCRIPTOR)
        field(TASKSTATUS_DESCRIPTOR)
        field(TASKTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDITDETAILS_DESCRIPTOR.index -> builder.auditDetails =
                    deserializer.deserializeMap(AUDITDETAILS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, AuditCheckDetails>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeAuditCheckDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SCHEDULEDAUDITNAME_DESCRIPTOR.index -> builder.scheduledAuditName = deserializeString()
                TASKSTARTTIME_DESCRIPTOR.index -> builder.taskStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TASKSTATISTICS_DESCRIPTOR.index -> builder.taskStatistics = deserializeTaskStatisticsDocument(deserializer)
                TASKSTATUS_DESCRIPTOR.index -> builder.taskStatus = deserializeString().let { AuditTaskStatus.fromValue(it) }
                TASKTYPE_DESCRIPTOR.index -> builder.taskType = deserializeString().let { AuditTaskType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
