// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.DescribeAuditSuppressionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ResourceIdentifier
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAuditSuppressionOperationDeserializer: HttpDeserialize<DescribeAuditSuppressionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAuditSuppressionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAuditSuppressionError(context, response)
        }
        val builder = DescribeAuditSuppressionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAuditSuppressionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAuditSuppressionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAuditSuppressionOperationBody(builder: DescribeAuditSuppressionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHECKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("checkName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXPIRATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expirationDate"))
    val RESOURCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceIdentifier"))
    val SUPPRESSINDEFINITELY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("suppressIndefinitely"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHECKNAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXPIRATIONDATE_DESCRIPTOR)
        field(RESOURCEIDENTIFIER_DESCRIPTOR)
        field(SUPPRESSINDEFINITELY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHECKNAME_DESCRIPTOR.index -> builder.checkName = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXPIRATIONDATE_DESCRIPTOR.index -> builder.expirationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESOURCEIDENTIFIER_DESCRIPTOR.index -> builder.resourceIdentifier = deserializeResourceIdentifierDocument(deserializer)
                SUPPRESSINDEFINITELY_DESCRIPTOR.index -> builder.suppressIndefinitely = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
