// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.AuditCheckConfiguration
import aws.sdk.kotlin.services.iot.model.AuditNotificationTarget
import aws.sdk.kotlin.services.iot.model.DescribeAccountAuditConfigurationResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class DescribeAccountAuditConfigurationOperationDeserializer: HttpDeserialize<DescribeAccountAuditConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAccountAuditConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAccountAuditConfigurationError(context, response)
        }
        val builder = DescribeAccountAuditConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccountAuditConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAccountAuditConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountAuditConfigurationOperationBody(builder: DescribeAccountAuditConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDITCHECKCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("auditCheckConfigurations"))
    val AUDITNOTIFICATIONTARGETCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("auditNotificationTargetConfigurations"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDITCHECKCONFIGURATIONS_DESCRIPTOR)
        field(AUDITNOTIFICATIONTARGETCONFIGURATIONS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDITCHECKCONFIGURATIONS_DESCRIPTOR.index -> builder.auditCheckConfigurations =
                    deserializer.deserializeMap(AUDITCHECKCONFIGURATIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, AuditCheckConfiguration>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeAuditCheckConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                AUDITNOTIFICATIONTARGETCONFIGURATIONS_DESCRIPTOR.index -> builder.auditNotificationTargetConfigurations =
                    deserializer.deserializeMap(AUDITNOTIFICATIONTARGETCONFIGURATIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, AuditNotificationTarget>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeAuditNotificationTargetDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
