// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.CreateProvisioningTemplateVersionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProvisioningTemplateVersionOperationDeserializer: HttpDeserialize<CreateProvisioningTemplateVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateProvisioningTemplateVersionResponse {
        if (!response.status.isSuccess()) {
            throwCreateProvisioningTemplateVersionError(context, response)
        }
        val builder = CreateProvisioningTemplateVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateProvisioningTemplateVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateProvisioningTemplateVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictingResourceUpdateException" -> ConflictingResourceUpdateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "VersionsLimitExceededException" -> VersionsLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateProvisioningTemplateVersionOperationBody(builder: CreateProvisioningTemplateVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ISDEFAULTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isDefaultVersion"))
    val TEMPLATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateArn"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateName"))
    val VERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("versionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ISDEFAULTVERSION_DESCRIPTOR)
        field(TEMPLATEARN_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
        field(VERSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISDEFAULTVERSION_DESCRIPTOR.index -> builder.isDefaultVersion = deserializeBoolean()
                TEMPLATEARN_DESCRIPTOR.index -> builder.templateArn = deserializeString()
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                VERSIONID_DESCRIPTOR.index -> builder.versionId = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
