// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.CancelJobExecutionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CancelJobExecutionOperationSerializer: HttpSerialize<CancelJobExecutionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CancelJobExecutionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "things",
                "${input.thingName}".encodeLabel(),
                "jobs",
                "${input.jobId}".encodeLabel(),
                "cancel",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.force != false) append("force", "${input.force}")
            }
        }

        val payload = serializeCancelJobExecutionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCancelJobExecutionOperationBody(context: ExecutionContext, input: CancelJobExecutionRequest): ByteArray {
    val serializer = JsonSerializer()
    val EXPECTEDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("expectedVersion"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("statusDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPECTEDVERSION_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.expectedVersion?.let { field(EXPECTEDVERSION_DESCRIPTOR, it) }
        if (input.statusDetails != null) {
            mapField(STATUSDETAILS_DESCRIPTOR) {
                input.statusDetails.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
