// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Specifies the date and time that a job will begin the rollout of the job document to all devices in the target group. Additionally, you can specify the end behavior for each job execution when it reaches the scheduled end time.
 */
public class SchedulingConfig private constructor(builder: Builder) {
    /**
     * Specifies the end behavior for all job executions after a job reaches the selected `endTime`. If `endTime` is not selected when creating the job, then `endBehavior` does not apply.
     */
    public val endBehavior: aws.sdk.kotlin.services.iot.model.JobEndBehavior? = builder.endBehavior
    /**
     * The time a job will stop rollout of the job document to all devices in the target group for a job. The `endTime` must take place no later than two years from the current time and be scheduled a minimum of thirty minutes from the current time. The minimum duration between `startTime` and `endTime` is thirty minutes. The maximum duration between `startTime` and `endTime` is two years.
     */
    public val endTime: kotlin.String? = builder.endTime
    /**
     * The time a job will begin rollout of the job document to all devices in the target group for a job. The `startTime` can be scheduled up to a year in advance and must be scheduled a minimum of thirty minutes from the current time.
     */
    public val startTime: kotlin.String? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.SchedulingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchedulingConfig(")
        append("endBehavior=$endBehavior,")
        append("endTime=$endTime,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endBehavior?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchedulingConfig

        if (endBehavior != other.endBehavior) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.SchedulingConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the end behavior for all job executions after a job reaches the selected `endTime`. If `endTime` is not selected when creating the job, then `endBehavior` does not apply.
         */
        public var endBehavior: aws.sdk.kotlin.services.iot.model.JobEndBehavior? = null
        /**
         * The time a job will stop rollout of the job document to all devices in the target group for a job. The `endTime` must take place no later than two years from the current time and be scheduled a minimum of thirty minutes from the current time. The minimum duration between `startTime` and `endTime` is thirty minutes. The maximum duration between `startTime` and `endTime` is two years.
         */
        public var endTime: kotlin.String? = null
        /**
         * The time a job will begin rollout of the job document to all devices in the target group for a job. The `startTime` can be scheduled up to a year in advance and must be scheduled a minimum of thirty minutes from the current time.
         */
        public var startTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.SchedulingConfig) : this() {
            this.endBehavior = x.endBehavior
            this.endTime = x.endTime
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.SchedulingConfig = SchedulingConfig(this)
    }
}
