// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action that writes data to an Amazon Kinesis Firehose stream.
 */
public class FirehoseAction private constructor(builder: Builder) {
    /**
     * Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`[](https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html). The default value is `false`.
     *
     * When `batchMode` is `true` and the rule's SQL statement evaluates to an Array, each Array element forms one record in the `PutRecordBatch`[](https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html) request. The resulting array can't have more than 500 records.
     */
    public val batchMode: kotlin.Boolean? = builder.batchMode
    /**
     * The delivery stream name.
     */
    public val deliveryStreamName: kotlin.String? = builder.deliveryStreamName
    /**
     * The IAM role that grants access to the Amazon Kinesis Firehose stream.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A character separator that will be used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    public val separator: kotlin.String? = builder.separator

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.FirehoseAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirehoseAction(")
        append("batchMode=$batchMode,")
        append("deliveryStreamName=$deliveryStreamName,")
        append("roleArn=$roleArn,")
        append("separator=$separator")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchMode?.hashCode() ?: 0
        result = 31 * result + (deliveryStreamName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (separator?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirehoseAction

        if (batchMode != other.batchMode) return false
        if (deliveryStreamName != other.deliveryStreamName) return false
        if (roleArn != other.roleArn) return false
        if (separator != other.separator) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.FirehoseAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`[](https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html). The default value is `false`.
         *
         * When `batchMode` is `true` and the rule's SQL statement evaluates to an Array, each Array element forms one record in the `PutRecordBatch`[](https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html) request. The resulting array can't have more than 500 records.
         */
        public var batchMode: kotlin.Boolean? = null
        /**
         * The delivery stream name.
         */
        public var deliveryStreamName: kotlin.String? = null
        /**
         * The IAM role that grants access to the Amazon Kinesis Firehose stream.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A character separator that will be used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         */
        public var separator: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.FirehoseAction) : this() {
            this.batchMode = x.batchMode
            this.deliveryStreamName = x.deliveryStreamName
            this.roleArn = x.roleArn
            this.separator = x.separator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.FirehoseAction = FirehoseAction(this)
    }
}
