// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



public class DeleteJobExecutionRequest private constructor(builder: Builder) {
    /**
     * The ID of the job execution to be deleted. The `executionNumber` refers to the execution of a particular job on a particular device.
     *
     * Note that once a job execution is deleted, the `executionNumber` may be reused by IoT, so be sure you get and use the correct value here.
     */
    public val executionNumber: kotlin.Long? = requireNotNull(builder.executionNumber) { "A non-null value must be provided for executionNumber" }
    /**
     * (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.
     *
     * Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.
     */
    public val force: kotlin.Boolean = builder.force
    /**
     * The ID of the job whose execution on a particular device will be deleted.
     */
    public val jobId: kotlin.String? = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     *
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
     *
     * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
     *
     * The `namespaceId` feature is in public preview.
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * The name of the thing whose job execution will be deleted.
     */
    public val thingName: kotlin.String? = requireNotNull(builder.thingName) { "A non-null value must be provided for thingName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DeleteJobExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteJobExecutionRequest(")
        append("executionNumber=$executionNumber,")
        append("force=$force,")
        append("jobId=$jobId,")
        append("namespaceId=$namespaceId,")
        append("thingName=$thingName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionNumber?.hashCode() ?: 0
        result = 31 * result + (force.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (thingName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteJobExecutionRequest

        if (executionNumber != other.executionNumber) return false
        if (force != other.force) return false
        if (jobId != other.jobId) return false
        if (namespaceId != other.namespaceId) return false
        if (thingName != other.thingName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DeleteJobExecutionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the job execution to be deleted. The `executionNumber` refers to the execution of a particular job on a particular device.
         *
         * Note that once a job execution is deleted, the `executionNumber` may be reused by IoT, so be sure you get and use the correct value here.
         */
        public var executionNumber: kotlin.Long? = null
        /**
         * (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.
         *
         * Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.
         */
        public var force: kotlin.Boolean = false
        /**
         * The ID of the job whose execution on a particular device will be deleted.
         */
        public var jobId: kotlin.String? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         *
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
         *
         * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
         *
         * The `namespaceId` feature is in public preview.
         */
        public var namespaceId: kotlin.String? = null
        /**
         * The name of the thing whose job execution will be deleted.
         */
        public var thingName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DeleteJobExecutionRequest) : this() {
            this.executionNumber = x.executionNumber
            this.force = x.force
            this.jobId = x.jobId
            this.namespaceId = x.namespaceId
            this.thingName = x.thingName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DeleteJobExecutionRequest = DeleteJobExecutionRequest(this)
    }
}
