// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a certificate.
 */
public class CertificateDescription private constructor(builder: Builder) {
    /**
     * The certificate ID of the CA certificate used to sign this certificate.
     */
    public val caCertificateId: kotlin.String? = builder.caCertificateId
    /**
     * The ARN of the certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The ID of the certificate.
     */
    public val certificateId: kotlin.String? = builder.certificateId
    /**
     * The mode of the certificate.
     *
     * `DEFAULT`: A certificate in `DEFAULT` mode is either generated by Amazon Web Services IoT Core or registered with an issuer certificate authority (CA) in `DEFAULT` mode. Devices with certificates in `DEFAULT` mode aren't required to send the Server Name Indication (SNI) extension when connecting to Amazon Web Services IoT Core. However, to use features such as custom domains and VPC endpoints, we recommend that you use the SNI extension when connecting to Amazon Web Services IoT Core.
     *
     * `SNI_ONLY`: A certificate in `SNI_ONLY` mode is registered without an issuer CA. Devices with certificates in `SNI_ONLY` mode must send the SNI extension when connecting to Amazon Web Services IoT Core.
     *
     * For more information about the value for SNI extension, see [Transport security in IoT](https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html).
     */
    public val certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = builder.certificateMode
    /**
     * The certificate data, in PEM format.
     */
    public val certificatePem: kotlin.String? = builder.certificatePem
    /**
     * The date and time the certificate was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The customer version of the certificate.
     */
    public val customerVersion: kotlin.Int? = builder.customerVersion
    /**
     * The generation ID of the certificate.
     */
    public val generationId: kotlin.String? = builder.generationId
    /**
     * The date and time the certificate was last modified.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The ID of the Amazon Web Services account that owns the certificate.
     */
    public val ownedBy: kotlin.String? = builder.ownedBy
    /**
     * The ID of the Amazon Web Services account of the previous owner of the certificate.
     */
    public val previousOwnedBy: kotlin.String? = builder.previousOwnedBy
    /**
     * The status of the certificate.
     */
    public val status: aws.sdk.kotlin.services.iot.model.CertificateStatus? = builder.status
    /**
     * The transfer data.
     */
    public val transferData: aws.sdk.kotlin.services.iot.model.TransferData? = builder.transferData
    /**
     * When the certificate is valid.
     */
    public val validity: aws.sdk.kotlin.services.iot.model.CertificateValidity? = builder.validity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CertificateDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateDescription(")
        append("caCertificateId=$caCertificateId,")
        append("certificateArn=$certificateArn,")
        append("certificateId=$certificateId,")
        append("certificateMode=$certificateMode,")
        append("certificatePem=$certificatePem,")
        append("creationDate=$creationDate,")
        append("customerVersion=$customerVersion,")
        append("generationId=$generationId,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("ownedBy=$ownedBy,")
        append("previousOwnedBy=$previousOwnedBy,")
        append("status=$status,")
        append("transferData=$transferData,")
        append("validity=$validity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = caCertificateId?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (certificateId?.hashCode() ?: 0)
        result = 31 * result + (certificateMode?.hashCode() ?: 0)
        result = 31 * result + (certificatePem?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customerVersion ?: 0)
        result = 31 * result + (generationId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (ownedBy?.hashCode() ?: 0)
        result = 31 * result + (previousOwnedBy?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transferData?.hashCode() ?: 0)
        result = 31 * result + (validity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateDescription

        if (caCertificateId != other.caCertificateId) return false
        if (certificateArn != other.certificateArn) return false
        if (certificateId != other.certificateId) return false
        if (certificateMode != other.certificateMode) return false
        if (certificatePem != other.certificatePem) return false
        if (creationDate != other.creationDate) return false
        if (customerVersion != other.customerVersion) return false
        if (generationId != other.generationId) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (ownedBy != other.ownedBy) return false
        if (previousOwnedBy != other.previousOwnedBy) return false
        if (status != other.status) return false
        if (transferData != other.transferData) return false
        if (validity != other.validity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CertificateDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The certificate ID of the CA certificate used to sign this certificate.
         */
        public var caCertificateId: kotlin.String? = null
        /**
         * The ARN of the certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The ID of the certificate.
         */
        public var certificateId: kotlin.String? = null
        /**
         * The mode of the certificate.
         *
         * `DEFAULT`: A certificate in `DEFAULT` mode is either generated by Amazon Web Services IoT Core or registered with an issuer certificate authority (CA) in `DEFAULT` mode. Devices with certificates in `DEFAULT` mode aren't required to send the Server Name Indication (SNI) extension when connecting to Amazon Web Services IoT Core. However, to use features such as custom domains and VPC endpoints, we recommend that you use the SNI extension when connecting to Amazon Web Services IoT Core.
         *
         * `SNI_ONLY`: A certificate in `SNI_ONLY` mode is registered without an issuer CA. Devices with certificates in `SNI_ONLY` mode must send the SNI extension when connecting to Amazon Web Services IoT Core.
         *
         * For more information about the value for SNI extension, see [Transport security in IoT](https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html).
         */
        public var certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = null
        /**
         * The certificate data, in PEM format.
         */
        public var certificatePem: kotlin.String? = null
        /**
         * The date and time the certificate was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer version of the certificate.
         */
        public var customerVersion: kotlin.Int? = null
        /**
         * The generation ID of the certificate.
         */
        public var generationId: kotlin.String? = null
        /**
         * The date and time the certificate was last modified.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the Amazon Web Services account that owns the certificate.
         */
        public var ownedBy: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account of the previous owner of the certificate.
         */
        public var previousOwnedBy: kotlin.String? = null
        /**
         * The status of the certificate.
         */
        public var status: aws.sdk.kotlin.services.iot.model.CertificateStatus? = null
        /**
         * The transfer data.
         */
        public var transferData: aws.sdk.kotlin.services.iot.model.TransferData? = null
        /**
         * When the certificate is valid.
         */
        public var validity: aws.sdk.kotlin.services.iot.model.CertificateValidity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CertificateDescription) : this() {
            this.caCertificateId = x.caCertificateId
            this.certificateArn = x.certificateArn
            this.certificateId = x.certificateId
            this.certificateMode = x.certificateMode
            this.certificatePem = x.certificatePem
            this.creationDate = x.creationDate
            this.customerVersion = x.customerVersion
            this.generationId = x.generationId
            this.lastModifiedDate = x.lastModifiedDate
            this.ownedBy = x.ownedBy
            this.previousOwnedBy = x.previousOwnedBy
            this.status = x.status
            this.transferData = x.transferData
            this.validity = x.validity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CertificateDescription = CertificateDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TransferData] inside the given [block]
         */
        public fun transferData(block: aws.sdk.kotlin.services.iot.model.TransferData.Builder.() -> kotlin.Unit) {
            this.transferData = aws.sdk.kotlin.services.iot.model.TransferData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CertificateValidity] inside the given [block]
         */
        public fun validity(block: aws.sdk.kotlin.services.iot.model.CertificateValidity.Builder.() -> kotlin.Unit) {
            this.validity = aws.sdk.kotlin.services.iot.model.CertificateValidity.invoke(block)
        }
    }
}
