// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a CA certificate.
 */
public class CaCertificateDescription private constructor(builder: Builder) {
    /**
     * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and "DISABLE"
     */
    public val autoRegistrationStatus: aws.sdk.kotlin.services.iot.model.AutoRegistrationStatus? = builder.autoRegistrationStatus
    /**
     * The CA certificate ARN.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The CA certificate ID.
     */
    public val certificateId: kotlin.String? = builder.certificateId
    /**
     * The mode of the CA.
     *
     * All the device certificates that are registered using this CA will be registered in the same mode as the CA. For more information about certificate mode for device certificates, see [certificate mode](https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode).
     */
    public val certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = builder.certificateMode
    /**
     * The CA certificate data, in PEM format.
     */
    public val certificatePem: kotlin.String? = builder.certificatePem
    /**
     * The date the CA certificate was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The customer version of the CA certificate.
     */
    public val customerVersion: kotlin.Int? = builder.customerVersion
    /**
     * The generation ID of the CA certificate.
     */
    public val generationId: kotlin.String? = builder.generationId
    /**
     * The date the CA certificate was last modified.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The owner of the CA certificate.
     */
    public val ownedBy: kotlin.String? = builder.ownedBy
    /**
     * The status of a CA certificate.
     */
    public val status: aws.sdk.kotlin.services.iot.model.CaCertificateStatus? = builder.status
    /**
     * When the CA certificate is valid.
     */
    public val validity: aws.sdk.kotlin.services.iot.model.CertificateValidity? = builder.validity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CaCertificateDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CaCertificateDescription(")
        append("autoRegistrationStatus=$autoRegistrationStatus,")
        append("certificateArn=$certificateArn,")
        append("certificateId=$certificateId,")
        append("certificateMode=$certificateMode,")
        append("certificatePem=$certificatePem,")
        append("creationDate=$creationDate,")
        append("customerVersion=$customerVersion,")
        append("generationId=$generationId,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("ownedBy=$ownedBy,")
        append("status=$status,")
        append("validity=$validity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoRegistrationStatus?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (certificateId?.hashCode() ?: 0)
        result = 31 * result + (certificateMode?.hashCode() ?: 0)
        result = 31 * result + (certificatePem?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customerVersion ?: 0)
        result = 31 * result + (generationId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (ownedBy?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (validity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CaCertificateDescription

        if (autoRegistrationStatus != other.autoRegistrationStatus) return false
        if (certificateArn != other.certificateArn) return false
        if (certificateId != other.certificateId) return false
        if (certificateMode != other.certificateMode) return false
        if (certificatePem != other.certificatePem) return false
        if (creationDate != other.creationDate) return false
        if (customerVersion != other.customerVersion) return false
        if (generationId != other.generationId) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (ownedBy != other.ownedBy) return false
        if (status != other.status) return false
        if (validity != other.validity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CaCertificateDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and "DISABLE"
         */
        public var autoRegistrationStatus: aws.sdk.kotlin.services.iot.model.AutoRegistrationStatus? = null
        /**
         * The CA certificate ARN.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The CA certificate ID.
         */
        public var certificateId: kotlin.String? = null
        /**
         * The mode of the CA.
         *
         * All the device certificates that are registered using this CA will be registered in the same mode as the CA. For more information about certificate mode for device certificates, see [certificate mode](https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode).
         */
        public var certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = null
        /**
         * The CA certificate data, in PEM format.
         */
        public var certificatePem: kotlin.String? = null
        /**
         * The date the CA certificate was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer version of the CA certificate.
         */
        public var customerVersion: kotlin.Int? = null
        /**
         * The generation ID of the CA certificate.
         */
        public var generationId: kotlin.String? = null
        /**
         * The date the CA certificate was last modified.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The owner of the CA certificate.
         */
        public var ownedBy: kotlin.String? = null
        /**
         * The status of a CA certificate.
         */
        public var status: aws.sdk.kotlin.services.iot.model.CaCertificateStatus? = null
        /**
         * When the CA certificate is valid.
         */
        public var validity: aws.sdk.kotlin.services.iot.model.CertificateValidity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CaCertificateDescription) : this() {
            this.autoRegistrationStatus = x.autoRegistrationStatus
            this.certificateArn = x.certificateArn
            this.certificateId = x.certificateId
            this.certificateMode = x.certificateMode
            this.certificatePem = x.certificatePem
            this.creationDate = x.creationDate
            this.customerVersion = x.customerVersion
            this.generationId = x.generationId
            this.lastModifiedDate = x.lastModifiedDate
            this.ownedBy = x.ownedBy
            this.status = x.status
            this.validity = x.validity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CaCertificateDescription = CaCertificateDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CertificateValidity] inside the given [block]
         */
        public fun validity(block: aws.sdk.kotlin.services.iot.model.CertificateValidity.Builder.() -> kotlin.Unit) {
            this.validity = aws.sdk.kotlin.services.iot.model.CertificateValidity.invoke(block)
        }
    }
}
