// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an active Device Defender security profile behavior violation.
 */
public class ActiveViolation private constructor(builder: Builder) {
    /**
     * The behavior that is being violated.
     */
    public val behavior: aws.sdk.kotlin.services.iot.model.Behavior? = builder.behavior
    /**
     * The time the most recent violation occurred.
     */
    public val lastViolationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastViolationTime
    /**
     * The value of the metric (the measurement) that caused the most recent violation.
     */
    public val lastViolationValue: aws.sdk.kotlin.services.iot.model.MetricValue? = builder.lastViolationValue
    /**
     * The security profile with the behavior is in violation.
     */
    public val securityProfileName: kotlin.String? = builder.securityProfileName
    /**
     * The name of the thing responsible for the active violation.
     */
    public val thingName: kotlin.String? = builder.thingName
    /**
     * The verification state of the violation (detect alarm).
     */
    public val verificationState: aws.sdk.kotlin.services.iot.model.VerificationState? = builder.verificationState
    /**
     * The description of the verification state of the violation.
     */
    public val verificationStateDescription: kotlin.String? = builder.verificationStateDescription
    /**
     * The details of a violation event.
     */
    public val violationEventAdditionalInfo: aws.sdk.kotlin.services.iot.model.ViolationEventAdditionalInfo? = builder.violationEventAdditionalInfo
    /**
     * The ID of the active violation.
     */
    public val violationId: kotlin.String? = builder.violationId
    /**
     * The time the violation started.
     */
    public val violationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.violationStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ActiveViolation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveViolation(")
        append("behavior=$behavior,")
        append("lastViolationTime=$lastViolationTime,")
        append("lastViolationValue=$lastViolationValue,")
        append("securityProfileName=$securityProfileName,")
        append("thingName=$thingName,")
        append("verificationState=$verificationState,")
        append("verificationStateDescription=$verificationStateDescription,")
        append("violationEventAdditionalInfo=$violationEventAdditionalInfo,")
        append("violationId=$violationId,")
        append("violationStartTime=$violationStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behavior?.hashCode() ?: 0
        result = 31 * result + (lastViolationTime?.hashCode() ?: 0)
        result = 31 * result + (lastViolationValue?.hashCode() ?: 0)
        result = 31 * result + (securityProfileName?.hashCode() ?: 0)
        result = 31 * result + (thingName?.hashCode() ?: 0)
        result = 31 * result + (verificationState?.hashCode() ?: 0)
        result = 31 * result + (verificationStateDescription?.hashCode() ?: 0)
        result = 31 * result + (violationEventAdditionalInfo?.hashCode() ?: 0)
        result = 31 * result + (violationId?.hashCode() ?: 0)
        result = 31 * result + (violationStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveViolation

        if (behavior != other.behavior) return false
        if (lastViolationTime != other.lastViolationTime) return false
        if (lastViolationValue != other.lastViolationValue) return false
        if (securityProfileName != other.securityProfileName) return false
        if (thingName != other.thingName) return false
        if (verificationState != other.verificationState) return false
        if (verificationStateDescription != other.verificationStateDescription) return false
        if (violationEventAdditionalInfo != other.violationEventAdditionalInfo) return false
        if (violationId != other.violationId) return false
        if (violationStartTime != other.violationStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ActiveViolation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The behavior that is being violated.
         */
        public var behavior: aws.sdk.kotlin.services.iot.model.Behavior? = null
        /**
         * The time the most recent violation occurred.
         */
        public var lastViolationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value of the metric (the measurement) that caused the most recent violation.
         */
        public var lastViolationValue: aws.sdk.kotlin.services.iot.model.MetricValue? = null
        /**
         * The security profile with the behavior is in violation.
         */
        public var securityProfileName: kotlin.String? = null
        /**
         * The name of the thing responsible for the active violation.
         */
        public var thingName: kotlin.String? = null
        /**
         * The verification state of the violation (detect alarm).
         */
        public var verificationState: aws.sdk.kotlin.services.iot.model.VerificationState? = null
        /**
         * The description of the verification state of the violation.
         */
        public var verificationStateDescription: kotlin.String? = null
        /**
         * The details of a violation event.
         */
        public var violationEventAdditionalInfo: aws.sdk.kotlin.services.iot.model.ViolationEventAdditionalInfo? = null
        /**
         * The ID of the active violation.
         */
        public var violationId: kotlin.String? = null
        /**
         * The time the violation started.
         */
        public var violationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ActiveViolation) : this() {
            this.behavior = x.behavior
            this.lastViolationTime = x.lastViolationTime
            this.lastViolationValue = x.lastViolationValue
            this.securityProfileName = x.securityProfileName
            this.thingName = x.thingName
            this.verificationState = x.verificationState
            this.verificationStateDescription = x.verificationStateDescription
            this.violationEventAdditionalInfo = x.violationEventAdditionalInfo
            this.violationId = x.violationId
            this.violationStartTime = x.violationStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ActiveViolation = ActiveViolation(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.Behavior] inside the given [block]
         */
        public fun behavior(block: aws.sdk.kotlin.services.iot.model.Behavior.Builder.() -> kotlin.Unit) {
            this.behavior = aws.sdk.kotlin.services.iot.model.Behavior.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.MetricValue] inside the given [block]
         */
        public fun lastViolationValue(block: aws.sdk.kotlin.services.iot.model.MetricValue.Builder.() -> kotlin.Unit) {
            this.lastViolationValue = aws.sdk.kotlin.services.iot.model.MetricValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ViolationEventAdditionalInfo] inside the given [block]
         */
        public fun violationEventAdditionalInfo(block: aws.sdk.kotlin.services.iot.model.ViolationEventAdditionalInfo.Builder.() -> kotlin.Unit) {
            this.violationEventAdditionalInfo = aws.sdk.kotlin.services.iot.model.ViolationEventAdditionalInfo.invoke(block)
        }
    }
}
