// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.ThingGroupProperties
import aws.sdk.kotlin.services.iot.model.UpdateDynamicThingGroupRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDynamicThingGroupOperationSerializer: HttpSerialize<UpdateDynamicThingGroupRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateDynamicThingGroupRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "dynamic-thing-groups",
                "${input.thingGroupName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateDynamicThingGroupOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDynamicThingGroupOperationBody(context: ExecutionContext, input: UpdateDynamicThingGroupRequest): ByteArray {
    val serializer = JsonSerializer()
    val EXPECTEDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("expectedVersion"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val THINGGROUPPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("thingGroupProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPECTEDVERSION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(THINGGROUPPROPERTIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.expectedVersion?.let { field(EXPECTEDVERSION_DESCRIPTOR, it) }
        input.indexName?.let { field(INDEXNAME_DESCRIPTOR, it) }
        input.queryString?.let { field(QUERYSTRING_DESCRIPTOR, it) }
        input.queryVersion?.let { field(QUERYVERSION_DESCRIPTOR, it) }
        input.thingGroupProperties?.let { field(THINGGROUPPROPERTIES_DESCRIPTOR, it, ::serializeThingGroupPropertiesDocument) }
    }
    return serializer.toByteArray()
}
