// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.ReplaceTopicRuleRequest
import aws.sdk.kotlin.services.iot.model.TopicRulePayload
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class ReplaceTopicRuleOperationSerializer: HttpSerialize<ReplaceTopicRuleRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ReplaceTopicRuleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "rules",
                "${input.ruleName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.topicRulePayload != null) {
            val payload = serializeTopicRulePayloadPayload(input.topicRulePayload)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.topicRulePayload == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
