// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.DescribeJobResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.Job
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeJobOperationDeserializer: HttpDeserialize<DescribeJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeJobError(context, response)
        }
        val builder = DescribeJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeJobOperationBody(builder: DescribeJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOCUMENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("documentSource"))
    val JOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("job"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENTSOURCE_DESCRIPTOR)
        field(JOB_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOCUMENTSOURCE_DESCRIPTOR.index -> builder.documentSource = deserializeString()
                JOB_DESCRIPTOR.index -> builder.job = deserializeJobDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
