// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AlertTarget
import aws.sdk.kotlin.services.iot.model.Behavior
import aws.sdk.kotlin.services.iot.model.CreateSecurityProfileRequest
import aws.sdk.kotlin.services.iot.model.MetricToRetain
import aws.sdk.kotlin.services.iot.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSecurityProfileOperationSerializer: HttpSerialize<CreateSecurityProfileRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateSecurityProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "security-profiles",
                "${input.securityProfileName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateSecurityProfileOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateSecurityProfileOperationBody(context: ExecutionContext, input: CreateSecurityProfileRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALMETRICSTORETAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalMetricsToRetain"))
    val ADDITIONALMETRICSTORETAINV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalMetricsToRetainV2"))
    val ALERTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("alertTargets"))
    val BEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("behaviors"))
    val SECURITYPROFILEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("securityProfileDescription"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALMETRICSTORETAIN_DESCRIPTOR)
        field(ADDITIONALMETRICSTORETAINV2_DESCRIPTOR)
        field(ALERTTARGETS_DESCRIPTOR)
        field(BEHAVIORS_DESCRIPTOR)
        field(SECURITYPROFILEDESCRIPTION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalMetricsToRetain != null) {
            listField(ADDITIONALMETRICSTORETAIN_DESCRIPTOR) {
                for (el0 in input.additionalMetricsToRetain) {
                    serializeString(el0)
                }
            }
        }
        if (input.additionalMetricsToRetainV2 != null) {
            listField(ADDITIONALMETRICSTORETAINV2_DESCRIPTOR) {
                for (el0 in input.additionalMetricsToRetainV2) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricToRetainDocument))
                }
            }
        }
        if (input.alertTargets != null) {
            mapField(ALERTTARGETS_DESCRIPTOR) {
                input.alertTargets.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeAlertTargetDocument)) }
            }
        }
        if (input.behaviors != null) {
            listField(BEHAVIORS_DESCRIPTOR) {
                for (el0 in input.behaviors) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBehaviorDocument))
                }
            }
        }
        input.securityProfileDescription?.let { field(SECURITYPROFILEDESCRIPTION_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
