// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.CreateOtaUpdateResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.OtaUpdateStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOTAUpdateOperationDeserializer: HttpDeserialize<CreateOtaUpdateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateOtaUpdateResponse {
        if (!response.status.isSuccess()) {
            throwCreateOtaUpdateError(context, response)
        }
        val builder = CreateOtaUpdateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOTAUpdateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateOtaUpdateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOTAUpdateOperationBody(builder: CreateOtaUpdateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSIOTJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsIotJobArn"))
    val AWSIOTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsIotJobId"))
    val OTAUPDATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("otaUpdateArn"))
    val OTAUPDATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("otaUpdateId"))
    val OTAUPDATESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("otaUpdateStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSIOTJOBARN_DESCRIPTOR)
        field(AWSIOTJOBID_DESCRIPTOR)
        field(OTAUPDATEARN_DESCRIPTOR)
        field(OTAUPDATEID_DESCRIPTOR)
        field(OTAUPDATESTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSIOTJOBARN_DESCRIPTOR.index -> builder.awsIotJobArn = deserializeString()
                AWSIOTJOBID_DESCRIPTOR.index -> builder.awsIotJobId = deserializeString()
                OTAUPDATEARN_DESCRIPTOR.index -> builder.otaUpdateArn = deserializeString()
                OTAUPDATEID_DESCRIPTOR.index -> builder.otaUpdateId = deserializeString()
                OTAUPDATESTATUS_DESCRIPTOR.index -> builder.otaUpdateStatus = deserializeString().let { OtaUpdateStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
