// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The thing indexing configuration. For more information, see [Managing Thing Indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
 */
public class ThingIndexingConfiguration private constructor(builder: Builder) {
    /**
     * Contains custom field names and their data type.
     */
    public val customFields: List<Field>? = builder.customFields
    /**
     * Device Defender indexing mode. Valid values are:
     * + VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing, *deviceDefenderIndexingMode* must not be set to OFF.
     * + OFF - Device Defender indexing is disabled.
     *
     * For more information about Device Defender violations, see [Device Defender Detect.](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html)
     */
    public val deviceDefenderIndexingMode: aws.sdk.kotlin.services.iot.model.DeviceDefenderIndexingMode? = builder.deviceDefenderIndexingMode
    /**
     * Provides additional filters for specific data sources. Named shadow is the only data source that currently supports and requires a filter. To add named shadows to your fleet indexing configuration, set `namedShadowIndexingMode` to be `ON` and specify your shadow names in `filter`.
     */
    public val filter: aws.sdk.kotlin.services.iot.model.IndexingFilter? = builder.filter
    /**
     * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
     */
    public val managedFields: List<Field>? = builder.managedFields
    /**
     * Named shadow indexing mode. Valid values are:
     * + ON – Your thing index contains named shadow. To enable thing named shadow indexing, *namedShadowIndexingMode* must not be set to OFF.
     * + OFF - Named shadow indexing is disabled.
     *
     * For more information about Shadows, see [IoT Device Shadow service.](https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html)
     */
    public val namedShadowIndexingMode: aws.sdk.kotlin.services.iot.model.NamedShadowIndexingMode? = builder.namedShadowIndexingMode
    /**
     * Thing connectivity indexing mode. Valid values are:
     * + STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, *thingIndexMode* must not be set to OFF.
     * + OFF - Thing connectivity status indexing is disabled.
     */
    public val thingConnectivityIndexingMode: aws.sdk.kotlin.services.iot.model.ThingConnectivityIndexingMode? = builder.thingConnectivityIndexingMode
    /**
     * Thing indexing mode. Valid values are:
     * + REGISTRY – Your thing index contains registry data only.
     * + REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * + OFF - Thing indexing is disabled.
     */
    public val thingIndexingMode: aws.sdk.kotlin.services.iot.model.ThingIndexingMode? = builder.thingIndexingMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ThingIndexingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThingIndexingConfiguration(")
        append("customFields=$customFields,")
        append("deviceDefenderIndexingMode=$deviceDefenderIndexingMode,")
        append("filter=$filter,")
        append("managedFields=$managedFields,")
        append("namedShadowIndexingMode=$namedShadowIndexingMode,")
        append("thingConnectivityIndexingMode=$thingConnectivityIndexingMode,")
        append("thingIndexingMode=$thingIndexingMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customFields?.hashCode() ?: 0
        result = 31 * result + (deviceDefenderIndexingMode?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (managedFields?.hashCode() ?: 0)
        result = 31 * result + (namedShadowIndexingMode?.hashCode() ?: 0)
        result = 31 * result + (thingConnectivityIndexingMode?.hashCode() ?: 0)
        result = 31 * result + (thingIndexingMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThingIndexingConfiguration

        if (customFields != other.customFields) return false
        if (deviceDefenderIndexingMode != other.deviceDefenderIndexingMode) return false
        if (filter != other.filter) return false
        if (managedFields != other.managedFields) return false
        if (namedShadowIndexingMode != other.namedShadowIndexingMode) return false
        if (thingConnectivityIndexingMode != other.thingConnectivityIndexingMode) return false
        if (thingIndexingMode != other.thingIndexingMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ThingIndexingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains custom field names and their data type.
         */
        public var customFields: List<Field>? = null
        /**
         * Device Defender indexing mode. Valid values are:
         * + VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing, *deviceDefenderIndexingMode* must not be set to OFF.
         * + OFF - Device Defender indexing is disabled.
         *
         * For more information about Device Defender violations, see [Device Defender Detect.](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html)
         */
        public var deviceDefenderIndexingMode: aws.sdk.kotlin.services.iot.model.DeviceDefenderIndexingMode? = null
        /**
         * Provides additional filters for specific data sources. Named shadow is the only data source that currently supports and requires a filter. To add named shadows to your fleet indexing configuration, set `namedShadowIndexingMode` to be `ON` and specify your shadow names in `filter`.
         */
        public var filter: aws.sdk.kotlin.services.iot.model.IndexingFilter? = null
        /**
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         */
        public var managedFields: List<Field>? = null
        /**
         * Named shadow indexing mode. Valid values are:
         * + ON – Your thing index contains named shadow. To enable thing named shadow indexing, *namedShadowIndexingMode* must not be set to OFF.
         * + OFF - Named shadow indexing is disabled.
         *
         * For more information about Shadows, see [IoT Device Shadow service.](https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html)
         */
        public var namedShadowIndexingMode: aws.sdk.kotlin.services.iot.model.NamedShadowIndexingMode? = null
        /**
         * Thing connectivity indexing mode. Valid values are:
         * + STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, *thingIndexMode* must not be set to OFF.
         * + OFF - Thing connectivity status indexing is disabled.
         */
        public var thingConnectivityIndexingMode: aws.sdk.kotlin.services.iot.model.ThingConnectivityIndexingMode? = null
        /**
         * Thing indexing mode. Valid values are:
         * + REGISTRY – Your thing index contains registry data only.
         * + REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * + OFF - Thing indexing is disabled.
         */
        public var thingIndexingMode: aws.sdk.kotlin.services.iot.model.ThingIndexingMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ThingIndexingConfiguration) : this() {
            this.customFields = x.customFields
            this.deviceDefenderIndexingMode = x.deviceDefenderIndexingMode
            this.filter = x.filter
            this.managedFields = x.managedFields
            this.namedShadowIndexingMode = x.namedShadowIndexingMode
            this.thingConnectivityIndexingMode = x.thingConnectivityIndexingMode
            this.thingIndexingMode = x.thingIndexingMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ThingIndexingConfiguration = ThingIndexingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.IndexingFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.iot.model.IndexingFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.iot.model.IndexingFilter.invoke(block)
        }
    }
}
