// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Information about the scheduled audit.
 */
public class ScheduledAuditMetadata private constructor(builder: Builder) {
    /**
     * The day of the month on which the scheduled audit is run (if the `frequency` is "MONTHLY"). If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
     */
    public val dayOfMonth: kotlin.String? = builder.dayOfMonth
    /**
     * The day of the week on which the scheduled audit is run (if the `frequency` is "WEEKLY" or "BIWEEKLY").
     */
    public val dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = builder.dayOfWeek
    /**
     * How often the scheduled audit occurs.
     */
    public val frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = builder.frequency
    /**
     * The ARN of the scheduled audit.
     */
    public val scheduledAuditArn: kotlin.String? = builder.scheduledAuditArn
    /**
     * The name of the scheduled audit.
     */
    public val scheduledAuditName: kotlin.String? = builder.scheduledAuditName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ScheduledAuditMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledAuditMetadata(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("frequency=$frequency,")
        append("scheduledAuditArn=$scheduledAuditArn,")
        append("scheduledAuditName=$scheduledAuditName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth?.hashCode() ?: 0
        result = 31 * result + (dayOfWeek?.hashCode() ?: 0)
        result = 31 * result + (frequency?.hashCode() ?: 0)
        result = 31 * result + (scheduledAuditArn?.hashCode() ?: 0)
        result = 31 * result + (scheduledAuditName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledAuditMetadata

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (frequency != other.frequency) return false
        if (scheduledAuditArn != other.scheduledAuditArn) return false
        if (scheduledAuditName != other.scheduledAuditName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ScheduledAuditMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The day of the month on which the scheduled audit is run (if the `frequency` is "MONTHLY"). If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
         */
        public var dayOfMonth: kotlin.String? = null
        /**
         * The day of the week on which the scheduled audit is run (if the `frequency` is "WEEKLY" or "BIWEEKLY").
         */
        public var dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = null
        /**
         * How often the scheduled audit occurs.
         */
        public var frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = null
        /**
         * The ARN of the scheduled audit.
         */
        public var scheduledAuditArn: kotlin.String? = null
        /**
         * The name of the scheduled audit.
         */
        public var scheduledAuditName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ScheduledAuditMetadata) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.frequency = x.frequency
            this.scheduledAuditArn = x.scheduledAuditArn
            this.scheduledAuditName = x.scheduledAuditName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ScheduledAuditMetadata = ScheduledAuditMetadata(this)
    }
}
