// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The Amazon Location rule action sends device location updates from an MQTT message to an Amazon Location tracker resource.
 */
public class LocationAction private constructor(builder: Builder) {
    /**
     * The unique ID of the device providing the location data.
     */
    public val deviceId: kotlin.String? = builder.deviceId
    /**
     * A string that evaluates to a double value that represents the latitude of the device's location.
     */
    public val latitude: kotlin.String? = builder.latitude
    /**
     * A string that evaluates to a double value that represents the longitude of the device's location.
     */
    public val longitude: kotlin.String? = builder.longitude
    /**
     * The IAM role that grants permission to write to the Amazon Location resource.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The time that the location data was sampled. The default value is the time the MQTT message was processed.
     */
    public val timestamp: aws.sdk.kotlin.services.iot.model.LocationTimestamp? = builder.timestamp
    /**
     * The name of the tracker resource in Amazon Location in which the location is updated.
     */
    public val trackerName: kotlin.String? = builder.trackerName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.LocationAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationAction(")
        append("deviceId=$deviceId,")
        append("latitude=$latitude,")
        append("longitude=$longitude,")
        append("roleArn=$roleArn,")
        append("timestamp=$timestamp,")
        append("trackerName=$trackerName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceId?.hashCode() ?: 0
        result = 31 * result + (latitude?.hashCode() ?: 0)
        result = 31 * result + (longitude?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (trackerName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationAction

        if (deviceId != other.deviceId) return false
        if (latitude != other.latitude) return false
        if (longitude != other.longitude) return false
        if (roleArn != other.roleArn) return false
        if (timestamp != other.timestamp) return false
        if (trackerName != other.trackerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.LocationAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of the device providing the location data.
         */
        public var deviceId: kotlin.String? = null
        /**
         * A string that evaluates to a double value that represents the latitude of the device's location.
         */
        public var latitude: kotlin.String? = null
        /**
         * A string that evaluates to a double value that represents the longitude of the device's location.
         */
        public var longitude: kotlin.String? = null
        /**
         * The IAM role that grants permission to write to the Amazon Location resource.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The time that the location data was sampled. The default value is the time the MQTT message was processed.
         */
        public var timestamp: aws.sdk.kotlin.services.iot.model.LocationTimestamp? = null
        /**
         * The name of the tracker resource in Amazon Location in which the location is updated.
         */
        public var trackerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.LocationAction) : this() {
            this.deviceId = x.deviceId
            this.latitude = x.latitude
            this.longitude = x.longitude
            this.roleArn = x.roleArn
            this.timestamp = x.timestamp
            this.trackerName = x.trackerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.LocationAction = LocationAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.LocationTimestamp] inside the given [block]
         */
        public fun timestamp(block: aws.sdk.kotlin.services.iot.model.LocationTimestamp.Builder.() -> kotlin.Unit) {
            this.timestamp = aws.sdk.kotlin.services.iot.model.LocationTimestamp.invoke(block)
        }
    }
}
