// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The job execution object represents the execution of a job on a particular device.
 */
public class JobExecution private constructor(builder: Builder) {
    /**
     * The estimated number of seconds that remain before the job execution status will be changed to `TIMED_OUT`. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated duration. This value will not be included if the job execution has reached a terminal status.
     */
    public val approximateSecondsBeforeTimedOut: kotlin.Long? = builder.approximateSecondsBeforeTimedOut
    /**
     * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this particular device. It can be used in commands which return or update job execution information.
     */
    public val executionNumber: kotlin.Long? = builder.executionNumber
    /**
     * Will be `true` if the job execution was canceled with the optional `force` parameter set to `true`.
     */
    public val forceCanceled: kotlin.Boolean? = builder.forceCanceled
    /**
     * The unique identifier you assigned to the job when it was created.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The time, in seconds since the epoch, when the job execution was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The time, in seconds since the epoch, when the job execution was queued.
     */
    public val queuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.queuedAt
    /**
     * The time, in seconds since the epoch, when the job execution started.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).
     */
    public val status: aws.sdk.kotlin.services.iot.model.JobExecutionStatus? = builder.status
    /**
     * A collection of name/value pairs that describe the status of the job execution.
     */
    public val statusDetails: aws.sdk.kotlin.services.iot.model.JobExecutionStatusDetails? = builder.statusDetails
    /**
     * The ARN of the thing on which the job execution is running.
     */
    public val thingArn: kotlin.String? = builder.thingArn
    /**
     * The version of the job execution. Job execution versions are incremented each time they are updated by a device.
     */
    public val versionNumber: kotlin.Long = builder.versionNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.JobExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobExecution(")
        append("approximateSecondsBeforeTimedOut=$approximateSecondsBeforeTimedOut,")
        append("executionNumber=$executionNumber,")
        append("forceCanceled=$forceCanceled,")
        append("jobId=$jobId,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("queuedAt=$queuedAt,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("thingArn=$thingArn,")
        append("versionNumber=$versionNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approximateSecondsBeforeTimedOut?.hashCode() ?: 0
        result = 31 * result + (executionNumber?.hashCode() ?: 0)
        result = 31 * result + (forceCanceled?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (queuedAt?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (thingArn?.hashCode() ?: 0)
        result = 31 * result + (versionNumber.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobExecution

        if (approximateSecondsBeforeTimedOut != other.approximateSecondsBeforeTimedOut) return false
        if (executionNumber != other.executionNumber) return false
        if (forceCanceled != other.forceCanceled) return false
        if (jobId != other.jobId) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (queuedAt != other.queuedAt) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (thingArn != other.thingArn) return false
        if (versionNumber != other.versionNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.JobExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The estimated number of seconds that remain before the job execution status will be changed to `TIMED_OUT`. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated duration. This value will not be included if the job execution has reached a terminal status.
         */
        public var approximateSecondsBeforeTimedOut: kotlin.Long? = null
        /**
         * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this particular device. It can be used in commands which return or update job execution information.
         */
        public var executionNumber: kotlin.Long? = null
        /**
         * Will be `true` if the job execution was canceled with the optional `force` parameter set to `true`.
         */
        public var forceCanceled: kotlin.Boolean? = null
        /**
         * The unique identifier you assigned to the job when it was created.
         */
        public var jobId: kotlin.String? = null
        /**
         * The time, in seconds since the epoch, when the job execution was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in seconds since the epoch, when the job execution was queued.
         */
        public var queuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in seconds since the epoch, when the job execution started.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).
         */
        public var status: aws.sdk.kotlin.services.iot.model.JobExecutionStatus? = null
        /**
         * A collection of name/value pairs that describe the status of the job execution.
         */
        public var statusDetails: aws.sdk.kotlin.services.iot.model.JobExecutionStatusDetails? = null
        /**
         * The ARN of the thing on which the job execution is running.
         */
        public var thingArn: kotlin.String? = null
        /**
         * The version of the job execution. Job execution versions are incremented each time they are updated by a device.
         */
        public var versionNumber: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.JobExecution) : this() {
            this.approximateSecondsBeforeTimedOut = x.approximateSecondsBeforeTimedOut
            this.executionNumber = x.executionNumber
            this.forceCanceled = x.forceCanceled
            this.jobId = x.jobId
            this.lastUpdatedAt = x.lastUpdatedAt
            this.queuedAt = x.queuedAt
            this.startedAt = x.startedAt
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.thingArn = x.thingArn
            this.versionNumber = x.versionNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.JobExecution = JobExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionStatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.iot.model.JobExecutionStatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.iot.model.JobExecutionStatusDetails.invoke(block)
        }
    }
}
