// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The criteria that determine when and how a job abort takes place.
 */
public class AwsJobAbortCriteria private constructor(builder: Builder) {
    /**
     * The type of job action to take to initiate the job abort.
     */
    public val action: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaAbortAction? = builder.action
    /**
     * The type of job execution failures that can initiate a job abort.
     */
    public val failureType: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaFailureType? = builder.failureType
    /**
     * The minimum number of things which must receive job execution notifications before the job can be aborted.
     */
    public val minNumberOfExecutedThings: kotlin.Int? = builder.minNumberOfExecutedThings
    /**
     * The minimum percentage of job execution failures that must occur to initiate the job abort.
     *
     * Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).
     */
    public val thresholdPercentage: kotlin.Double? = builder.thresholdPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsJobAbortCriteria(")
        append("action=$action,")
        append("failureType=$failureType,")
        append("minNumberOfExecutedThings=$minNumberOfExecutedThings,")
        append("thresholdPercentage=$thresholdPercentage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (failureType?.hashCode() ?: 0)
        result = 31 * result + (minNumberOfExecutedThings ?: 0)
        result = 31 * result + (thresholdPercentage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsJobAbortCriteria

        if (action != other.action) return false
        if (failureType != other.failureType) return false
        if (minNumberOfExecutedThings != other.minNumberOfExecutedThings) return false
        if (thresholdPercentage != other.thresholdPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of job action to take to initiate the job abort.
         */
        public var action: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaAbortAction? = null
        /**
         * The type of job execution failures that can initiate a job abort.
         */
        public var failureType: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaFailureType? = null
        /**
         * The minimum number of things which must receive job execution notifications before the job can be aborted.
         */
        public var minNumberOfExecutedThings: kotlin.Int? = null
        /**
         * The minimum percentage of job execution failures that must occur to initiate the job abort.
         *
         * Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).
         */
        public var thresholdPercentage: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria) : this() {
            this.action = x.action
            this.failureType = x.failureType
            this.minNumberOfExecutedThings = x.minNumberOfExecutedThings
            this.thresholdPercentage = x.thresholdPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria = AwsJobAbortCriteria(this)
    }
}
