// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes the actions associated with a rule.
 */
public class Action private constructor(builder: Builder) {
    /**
     * Change the state of a CloudWatch alarm.
     */
    public val cloudwatchAlarm: aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction? = builder.cloudwatchAlarm
    /**
     * Send data to CloudWatch Logs.
     */
    public val cloudwatchLogs: aws.sdk.kotlin.services.iot.model.CloudwatchLogsAction? = builder.cloudwatchLogs
    /**
     * Capture a CloudWatch metric.
     */
    public val cloudwatchMetric: aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction? = builder.cloudwatchMetric
    /**
     * Write to a DynamoDB table.
     */
    public val dynamoDb: aws.sdk.kotlin.services.iot.model.DynamoDbAction? = builder.dynamoDb
    /**
     * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.
     */
    public val dynamoDbV2: aws.sdk.kotlin.services.iot.model.DynamoDbV2Action? = builder.dynamoDbV2
    /**
     * Write data to an Amazon OpenSearch Service domain.
     *
     * The `Elasticsearch` action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the `OpenSearch` rule action instead. For more information, see [OpenSearchAction](https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html).
     */
    public val elasticsearch: aws.sdk.kotlin.services.iot.model.ElasticsearchAction? = builder.elasticsearch
    /**
     * Write to an Amazon Kinesis Firehose stream.
     */
    public val firehose: aws.sdk.kotlin.services.iot.model.FirehoseAction? = builder.firehose
    /**
     * Send data to an HTTPS endpoint.
     */
    public val http: aws.sdk.kotlin.services.iot.model.HttpAction? = builder.http
    /**
     * Sends message data to an IoT Analytics channel.
     */
    public val iotAnalytics: aws.sdk.kotlin.services.iot.model.IotAnalyticsAction? = builder.iotAnalytics
    /**
     * Sends an input to an IoT Events detector.
     */
    public val iotEvents: aws.sdk.kotlin.services.iot.model.IotEventsAction? = builder.iotEvents
    /**
     * Sends data from the MQTT message that triggered the rule to IoT SiteWise asset properties.
     */
    public val iotSiteWise: aws.sdk.kotlin.services.iot.model.IotSiteWiseAction? = builder.iotSiteWise
    /**
     * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
     */
    public val kafka: aws.sdk.kotlin.services.iot.model.KafkaAction? = builder.kafka
    /**
     * Write data to an Amazon Kinesis stream.
     */
    public val kinesis: aws.sdk.kotlin.services.iot.model.KinesisAction? = builder.kinesis
    /**
     * Invoke a Lambda function.
     */
    public val lambda: aws.sdk.kotlin.services.iot.model.LambdaAction? = builder.lambda
    /**
     * The Amazon Location Service rule action sends device location updates from an MQTT message to an Amazon Location tracker resource.
     */
    public val location: aws.sdk.kotlin.services.iot.model.LocationAction? = builder.location
    /**
     * Write data to an Amazon OpenSearch Service domain.
     */
    public val openSearch: aws.sdk.kotlin.services.iot.model.OpenSearchAction? = builder.openSearch
    /**
     * Publish to another MQTT topic.
     */
    public val republish: aws.sdk.kotlin.services.iot.model.RepublishAction? = builder.republish
    /**
     * Write to an Amazon S3 bucket.
     */
    public val s3: aws.sdk.kotlin.services.iot.model.S3Action? = builder.s3
    /**
     * Send a message to a Salesforce IoT Cloud Input Stream.
     */
    public val salesforce: aws.sdk.kotlin.services.iot.model.SalesforceAction? = builder.salesforce
    /**
     * Publish to an Amazon SNS topic.
     */
    public val sns: aws.sdk.kotlin.services.iot.model.SnsAction? = builder.sns
    /**
     * Publish to an Amazon SQS queue.
     */
    public val sqs: aws.sdk.kotlin.services.iot.model.SqsAction? = builder.sqs
    /**
     * Starts execution of a Step Functions state machine.
     */
    public val stepFunctions: aws.sdk.kotlin.services.iot.model.StepFunctionsAction? = builder.stepFunctions
    /**
     * The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table. For more information, see the [Timestream](https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html) topic rule action documentation.
     */
    public val timestream: aws.sdk.kotlin.services.iot.model.TimestreamAction? = builder.timestream

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("cloudwatchAlarm=$cloudwatchAlarm,")
        append("cloudwatchLogs=$cloudwatchLogs,")
        append("cloudwatchMetric=$cloudwatchMetric,")
        append("dynamoDb=$dynamoDb,")
        append("dynamoDbV2=$dynamoDbV2,")
        append("elasticsearch=$elasticsearch,")
        append("firehose=$firehose,")
        append("http=$http,")
        append("iotAnalytics=$iotAnalytics,")
        append("iotEvents=$iotEvents,")
        append("iotSiteWise=$iotSiteWise,")
        append("kafka=$kafka,")
        append("kinesis=$kinesis,")
        append("lambda=$lambda,")
        append("location=$location,")
        append("openSearch=$openSearch,")
        append("republish=$republish,")
        append("s3=$s3,")
        append("salesforce=$salesforce,")
        append("sns=$sns,")
        append("sqs=$sqs,")
        append("stepFunctions=$stepFunctions,")
        append("timestream=$timestream)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudwatchAlarm?.hashCode() ?: 0
        result = 31 * result + (cloudwatchLogs?.hashCode() ?: 0)
        result = 31 * result + (cloudwatchMetric?.hashCode() ?: 0)
        result = 31 * result + (dynamoDb?.hashCode() ?: 0)
        result = 31 * result + (dynamoDbV2?.hashCode() ?: 0)
        result = 31 * result + (elasticsearch?.hashCode() ?: 0)
        result = 31 * result + (firehose?.hashCode() ?: 0)
        result = 31 * result + (http?.hashCode() ?: 0)
        result = 31 * result + (iotAnalytics?.hashCode() ?: 0)
        result = 31 * result + (iotEvents?.hashCode() ?: 0)
        result = 31 * result + (iotSiteWise?.hashCode() ?: 0)
        result = 31 * result + (kafka?.hashCode() ?: 0)
        result = 31 * result + (kinesis?.hashCode() ?: 0)
        result = 31 * result + (lambda?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (openSearch?.hashCode() ?: 0)
        result = 31 * result + (republish?.hashCode() ?: 0)
        result = 31 * result + (s3?.hashCode() ?: 0)
        result = 31 * result + (salesforce?.hashCode() ?: 0)
        result = 31 * result + (sns?.hashCode() ?: 0)
        result = 31 * result + (sqs?.hashCode() ?: 0)
        result = 31 * result + (stepFunctions?.hashCode() ?: 0)
        result = 31 * result + (timestream?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (cloudwatchAlarm != other.cloudwatchAlarm) return false
        if (cloudwatchLogs != other.cloudwatchLogs) return false
        if (cloudwatchMetric != other.cloudwatchMetric) return false
        if (dynamoDb != other.dynamoDb) return false
        if (dynamoDbV2 != other.dynamoDbV2) return false
        if (elasticsearch != other.elasticsearch) return false
        if (firehose != other.firehose) return false
        if (http != other.http) return false
        if (iotAnalytics != other.iotAnalytics) return false
        if (iotEvents != other.iotEvents) return false
        if (iotSiteWise != other.iotSiteWise) return false
        if (kafka != other.kafka) return false
        if (kinesis != other.kinesis) return false
        if (lambda != other.lambda) return false
        if (location != other.location) return false
        if (openSearch != other.openSearch) return false
        if (republish != other.republish) return false
        if (s3 != other.s3) return false
        if (salesforce != other.salesforce) return false
        if (sns != other.sns) return false
        if (sqs != other.sqs) return false
        if (stepFunctions != other.stepFunctions) return false
        if (timestream != other.timestream) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.Action = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Change the state of a CloudWatch alarm.
         */
        public var cloudwatchAlarm: aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction? = null
        /**
         * Send data to CloudWatch Logs.
         */
        public var cloudwatchLogs: aws.sdk.kotlin.services.iot.model.CloudwatchLogsAction? = null
        /**
         * Capture a CloudWatch metric.
         */
        public var cloudwatchMetric: aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction? = null
        /**
         * Write to a DynamoDB table.
         */
        public var dynamoDb: aws.sdk.kotlin.services.iot.model.DynamoDbAction? = null
        /**
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.
         */
        public var dynamoDbV2: aws.sdk.kotlin.services.iot.model.DynamoDbV2Action? = null
        /**
         * Write data to an Amazon OpenSearch Service domain.
         *
         * The `Elasticsearch` action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the `OpenSearch` rule action instead. For more information, see [OpenSearchAction](https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html).
         */
        public var elasticsearch: aws.sdk.kotlin.services.iot.model.ElasticsearchAction? = null
        /**
         * Write to an Amazon Kinesis Firehose stream.
         */
        public var firehose: aws.sdk.kotlin.services.iot.model.FirehoseAction? = null
        /**
         * Send data to an HTTPS endpoint.
         */
        public var http: aws.sdk.kotlin.services.iot.model.HttpAction? = null
        /**
         * Sends message data to an IoT Analytics channel.
         */
        public var iotAnalytics: aws.sdk.kotlin.services.iot.model.IotAnalyticsAction? = null
        /**
         * Sends an input to an IoT Events detector.
         */
        public var iotEvents: aws.sdk.kotlin.services.iot.model.IotEventsAction? = null
        /**
         * Sends data from the MQTT message that triggered the rule to IoT SiteWise asset properties.
         */
        public var iotSiteWise: aws.sdk.kotlin.services.iot.model.IotSiteWiseAction? = null
        /**
         * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
         */
        public var kafka: aws.sdk.kotlin.services.iot.model.KafkaAction? = null
        /**
         * Write data to an Amazon Kinesis stream.
         */
        public var kinesis: aws.sdk.kotlin.services.iot.model.KinesisAction? = null
        /**
         * Invoke a Lambda function.
         */
        public var lambda: aws.sdk.kotlin.services.iot.model.LambdaAction? = null
        /**
         * The Amazon Location Service rule action sends device location updates from an MQTT message to an Amazon Location tracker resource.
         */
        public var location: aws.sdk.kotlin.services.iot.model.LocationAction? = null
        /**
         * Write data to an Amazon OpenSearch Service domain.
         */
        public var openSearch: aws.sdk.kotlin.services.iot.model.OpenSearchAction? = null
        /**
         * Publish to another MQTT topic.
         */
        public var republish: aws.sdk.kotlin.services.iot.model.RepublishAction? = null
        /**
         * Write to an Amazon S3 bucket.
         */
        public var s3: aws.sdk.kotlin.services.iot.model.S3Action? = null
        /**
         * Send a message to a Salesforce IoT Cloud Input Stream.
         */
        public var salesforce: aws.sdk.kotlin.services.iot.model.SalesforceAction? = null
        /**
         * Publish to an Amazon SNS topic.
         */
        public var sns: aws.sdk.kotlin.services.iot.model.SnsAction? = null
        /**
         * Publish to an Amazon SQS queue.
         */
        public var sqs: aws.sdk.kotlin.services.iot.model.SqsAction? = null
        /**
         * Starts execution of a Step Functions state machine.
         */
        public var stepFunctions: aws.sdk.kotlin.services.iot.model.StepFunctionsAction? = null
        /**
         * The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table. For more information, see the [Timestream](https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html) topic rule action documentation.
         */
        public var timestream: aws.sdk.kotlin.services.iot.model.TimestreamAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.Action) : this() {
            this.cloudwatchAlarm = x.cloudwatchAlarm
            this.cloudwatchLogs = x.cloudwatchLogs
            this.cloudwatchMetric = x.cloudwatchMetric
            this.dynamoDb = x.dynamoDb
            this.dynamoDbV2 = x.dynamoDbV2
            this.elasticsearch = x.elasticsearch
            this.firehose = x.firehose
            this.http = x.http
            this.iotAnalytics = x.iotAnalytics
            this.iotEvents = x.iotEvents
            this.iotSiteWise = x.iotSiteWise
            this.kafka = x.kafka
            this.kinesis = x.kinesis
            this.lambda = x.lambda
            this.location = x.location
            this.openSearch = x.openSearch
            this.republish = x.republish
            this.s3 = x.s3
            this.salesforce = x.salesforce
            this.sns = x.sns
            this.sqs = x.sqs
            this.stepFunctions = x.stepFunctions
            this.timestream = x.timestream
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.Action = Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction] inside the given [block]
         */
        public fun cloudwatchAlarm(block: aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction.Builder.() -> kotlin.Unit) {
            this.cloudwatchAlarm = aws.sdk.kotlin.services.iot.model.CloudwatchAlarmAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CloudwatchLogsAction] inside the given [block]
         */
        public fun cloudwatchLogs(block: aws.sdk.kotlin.services.iot.model.CloudwatchLogsAction.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogs = aws.sdk.kotlin.services.iot.model.CloudwatchLogsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction] inside the given [block]
         */
        public fun cloudwatchMetric(block: aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction.Builder.() -> kotlin.Unit) {
            this.cloudwatchMetric = aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.DynamoDbAction] inside the given [block]
         */
        public fun dynamoDb(block: aws.sdk.kotlin.services.iot.model.DynamoDbAction.Builder.() -> kotlin.Unit) {
            this.dynamoDb = aws.sdk.kotlin.services.iot.model.DynamoDbAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.DynamoDbV2Action] inside the given [block]
         */
        public fun dynamoDbV2(block: aws.sdk.kotlin.services.iot.model.DynamoDbV2Action.Builder.() -> kotlin.Unit) {
            this.dynamoDbV2 = aws.sdk.kotlin.services.iot.model.DynamoDbV2Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ElasticsearchAction] inside the given [block]
         */
        public fun elasticsearch(block: aws.sdk.kotlin.services.iot.model.ElasticsearchAction.Builder.() -> kotlin.Unit) {
            this.elasticsearch = aws.sdk.kotlin.services.iot.model.ElasticsearchAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.FirehoseAction] inside the given [block]
         */
        public fun firehose(block: aws.sdk.kotlin.services.iot.model.FirehoseAction.Builder.() -> kotlin.Unit) {
            this.firehose = aws.sdk.kotlin.services.iot.model.FirehoseAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.HttpAction] inside the given [block]
         */
        public fun http(block: aws.sdk.kotlin.services.iot.model.HttpAction.Builder.() -> kotlin.Unit) {
            this.http = aws.sdk.kotlin.services.iot.model.HttpAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.IotAnalyticsAction] inside the given [block]
         */
        public fun iotAnalytics(block: aws.sdk.kotlin.services.iot.model.IotAnalyticsAction.Builder.() -> kotlin.Unit) {
            this.iotAnalytics = aws.sdk.kotlin.services.iot.model.IotAnalyticsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.IotEventsAction] inside the given [block]
         */
        public fun iotEvents(block: aws.sdk.kotlin.services.iot.model.IotEventsAction.Builder.() -> kotlin.Unit) {
            this.iotEvents = aws.sdk.kotlin.services.iot.model.IotEventsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.IotSiteWiseAction] inside the given [block]
         */
        public fun iotSiteWise(block: aws.sdk.kotlin.services.iot.model.IotSiteWiseAction.Builder.() -> kotlin.Unit) {
            this.iotSiteWise = aws.sdk.kotlin.services.iot.model.IotSiteWiseAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.KafkaAction] inside the given [block]
         */
        public fun kafka(block: aws.sdk.kotlin.services.iot.model.KafkaAction.Builder.() -> kotlin.Unit) {
            this.kafka = aws.sdk.kotlin.services.iot.model.KafkaAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.KinesisAction] inside the given [block]
         */
        public fun kinesis(block: aws.sdk.kotlin.services.iot.model.KinesisAction.Builder.() -> kotlin.Unit) {
            this.kinesis = aws.sdk.kotlin.services.iot.model.KinesisAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.LambdaAction] inside the given [block]
         */
        public fun lambda(block: aws.sdk.kotlin.services.iot.model.LambdaAction.Builder.() -> kotlin.Unit) {
            this.lambda = aws.sdk.kotlin.services.iot.model.LambdaAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.LocationAction] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.iot.model.LocationAction.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.iot.model.LocationAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.OpenSearchAction] inside the given [block]
         */
        public fun openSearch(block: aws.sdk.kotlin.services.iot.model.OpenSearchAction.Builder.() -> kotlin.Unit) {
            this.openSearch = aws.sdk.kotlin.services.iot.model.OpenSearchAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.RepublishAction] inside the given [block]
         */
        public fun republish(block: aws.sdk.kotlin.services.iot.model.RepublishAction.Builder.() -> kotlin.Unit) {
            this.republish = aws.sdk.kotlin.services.iot.model.RepublishAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.S3Action] inside the given [block]
         */
        public fun s3(block: aws.sdk.kotlin.services.iot.model.S3Action.Builder.() -> kotlin.Unit) {
            this.s3 = aws.sdk.kotlin.services.iot.model.S3Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.SalesforceAction] inside the given [block]
         */
        public fun salesforce(block: aws.sdk.kotlin.services.iot.model.SalesforceAction.Builder.() -> kotlin.Unit) {
            this.salesforce = aws.sdk.kotlin.services.iot.model.SalesforceAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.SnsAction] inside the given [block]
         */
        public fun sns(block: aws.sdk.kotlin.services.iot.model.SnsAction.Builder.() -> kotlin.Unit) {
            this.sns = aws.sdk.kotlin.services.iot.model.SnsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.SqsAction] inside the given [block]
         */
        public fun sqs(block: aws.sdk.kotlin.services.iot.model.SqsAction.Builder.() -> kotlin.Unit) {
            this.sqs = aws.sdk.kotlin.services.iot.model.SqsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.StepFunctionsAction] inside the given [block]
         */
        public fun stepFunctions(block: aws.sdk.kotlin.services.iot.model.StepFunctionsAction.Builder.() -> kotlin.Unit) {
            this.stepFunctions = aws.sdk.kotlin.services.iot.model.StepFunctionsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimestreamAction] inside the given [block]
         */
        public fun timestream(block: aws.sdk.kotlin.services.iot.model.TimestreamAction.Builder.() -> kotlin.Unit) {
            this.timestream = aws.sdk.kotlin.services.iot.model.TimestreamAction.invoke(block)
        }
    }
}
