// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ProvisioningHook
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeProvisioningTemplateOperationDeserializer: HttpDeserialize<DescribeProvisioningTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProvisioningTemplateResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProvisioningTemplateError(context, response)
        }
        val builder = DescribeProvisioningTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProvisioningTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProvisioningTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisioningTemplateOperationBody(builder: DescribeProvisioningTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DEFAULTVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("defaultVersionId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enabled"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val PREPROVISIONINGHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("preProvisioningHook"))
    val PROVISIONINGROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("provisioningRoleArn"))
    val TEMPLATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateArn"))
    val TEMPLATEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateBody"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(DEFAULTVERSIONID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENABLED_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(PREPROVISIONINGHOOK_DESCRIPTOR)
        field(PROVISIONINGROLEARN_DESCRIPTOR)
        field(TEMPLATEARN_DESCRIPTOR)
        field(TEMPLATEBODY_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTVERSIONID_DESCRIPTOR.index -> builder.defaultVersionId = deserializeInt()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENABLED_DESCRIPTOR.index -> builder.enabled = deserializeBoolean()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                PREPROVISIONINGHOOK_DESCRIPTOR.index -> builder.preProvisioningHook = deserializeProvisioningHookDocument(deserializer)
                PROVISIONINGROLEARN_DESCRIPTOR.index -> builder.provisioningRoleArn = deserializeString()
                TEMPLATEARN_DESCRIPTOR.index -> builder.templateArn = deserializeString()
                TEMPLATEBODY_DESCRIPTOR.index -> builder.templateBody = deserializeString()
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
