// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class UpdateScheduledAuditRequest private constructor(builder: Builder) {
    /**
     * The day of the month on which the scheduled audit takes place. This can be `1` through `31` or `LAST`. This field is required if the `frequency` parameter is set to `MONTHLY`. If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
     */
    val dayOfMonth: kotlin.String? = builder.dayOfMonth
    /**
     * The day of the week on which the scheduled audit takes place. This can be one of `SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, or `SAT`. This field is required if the "frequency" parameter is set to `WEEKLY` or `BIWEEKLY`.
     */
    val dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = builder.dayOfWeek
    /**
     * How often the scheduled audit takes place, either `DAILY`, `WEEKLY`, `BIWEEKLY`, or `MONTHLY`. The start time of each audit is determined by the system.
     */
    val frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = builder.frequency
    /**
     * The name of the scheduled audit. (Max. 128 chars)
     */
    val scheduledAuditName: kotlin.String? = requireNotNull(builder.scheduledAuditName) { "A non-null value must be provided for scheduledAuditName" }
    /**
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
     */
    val targetCheckNames: List<String>? = builder.targetCheckNames

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateScheduledAuditRequest(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("frequency=$frequency,")
        append("scheduledAuditName=$scheduledAuditName,")
        append("targetCheckNames=$targetCheckNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth?.hashCode() ?: 0
        result = 31 * result + (dayOfWeek?.hashCode() ?: 0)
        result = 31 * result + (frequency?.hashCode() ?: 0)
        result = 31 * result + (scheduledAuditName?.hashCode() ?: 0)
        result = 31 * result + (targetCheckNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateScheduledAuditRequest

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (frequency != other.frequency) return false
        if (scheduledAuditName != other.scheduledAuditName) return false
        if (targetCheckNames != other.targetCheckNames) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The day of the month on which the scheduled audit takes place. This can be `1` through `31` or `LAST`. This field is required if the `frequency` parameter is set to `MONTHLY`. If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
         */
        var dayOfMonth: kotlin.String? = null
        /**
         * The day of the week on which the scheduled audit takes place. This can be one of `SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, or `SAT`. This field is required if the "frequency" parameter is set to `WEEKLY` or `BIWEEKLY`.
         */
        var dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = null
        /**
         * How often the scheduled audit takes place, either `DAILY`, `WEEKLY`, `BIWEEKLY`, or `MONTHLY`. The start time of each audit is determined by the system.
         */
        var frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = null
        /**
         * The name of the scheduled audit. (Max. 128 chars)
         */
        var scheduledAuditName: kotlin.String? = null
        /**
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
         */
        var targetCheckNames: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditRequest) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.frequency = x.frequency
            this.scheduledAuditName = x.scheduledAuditName
            this.targetCheckNames = x.targetCheckNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateScheduledAuditRequest = UpdateScheduledAuditRequest(this)
    }
}
