// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class ListJobExecutionsForThingRequest private constructor(builder: Builder) {
    /**
     * The unique identifier you assigned to this job when it was created.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The maximum number of results to be returned per request.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     *
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
     *
     * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
     *
     * The `namespaceId` feature is in public preview.
     */
    val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * The token to retrieve the next set of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * An optional filter that lets you search for jobs that have the specified status.
     */
    val status: aws.sdk.kotlin.services.iot.model.JobExecutionStatus? = builder.status
    /**
     * The thing name.
     */
    val thingName: kotlin.String? = requireNotNull(builder.thingName) { "A non-null value must be provided for thingName" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ListJobExecutionsForThingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListJobExecutionsForThingRequest(")
        append("jobId=$jobId,")
        append("maxResults=$maxResults,")
        append("namespaceId=$namespaceId,")
        append("nextToken=$nextToken,")
        append("status=$status,")
        append("thingName=$thingName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (thingName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListJobExecutionsForThingRequest

        if (jobId != other.jobId) return false
        if (maxResults != other.maxResults) return false
        if (namespaceId != other.namespaceId) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false
        if (thingName != other.thingName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ListJobExecutionsForThingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier you assigned to this job when it was created.
         */
        var jobId: kotlin.String? = null
        /**
         * The maximum number of results to be returned per request.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         *
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
         *
         * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
         *
         * The `namespaceId` feature is in public preview.
         */
        var namespaceId: kotlin.String? = null
        /**
         * The token to retrieve the next set of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * An optional filter that lets you search for jobs that have the specified status.
         */
        var status: aws.sdk.kotlin.services.iot.model.JobExecutionStatus? = null
        /**
         * The thing name.
         */
        var thingName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ListJobExecutionsForThingRequest) : this() {
            this.jobId = x.jobId
            this.maxResults = x.maxResults
            this.namespaceId = x.namespaceId
            this.nextToken = x.nextToken
            this.status = x.status
            this.thingName = x.thingName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ListJobExecutionsForThingRequest = ListJobExecutionsForThingRequest(this)
    }
}
