// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The `Job` object contains details about a job.
 */
class Job private constructor(builder: Builder) {
    /**
     * Configuration for criteria to abort the job.
     */
    val abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = builder.abortConfig
    /**
     * If the job was updated, describes the reason for the update.
     */
    val comment: kotlin.String? = builder.comment
    /**
     * The time, in seconds since the epoch, when the job was completed.
     */
    val completedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.completedAt
    /**
     * The time, in seconds since the epoch, when the job was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A short text description of the job.
     */
    val description: kotlin.String? = builder.description
    /**
     * A key-value map that pairs the patterns that need to be replaced in a managed template job document schema. You can use the description of each key as a guidance to specify the inputs during runtime when creating a job.
     *
     * `documentParameters` can only be used when creating jobs from Amazon Web Services managed templates. This parameter can't be used with custom job templates or to create jobs from them.
     */
    val documentParameters: Map<String, String>? = builder.documentParameters
    /**
     * Will be `true` if the job was canceled with the optional `force` parameter set to `true`.
     */
    val forceCanceled: kotlin.Boolean? = builder.forceCanceled
    val isConcurrent: kotlin.Boolean? = builder.isConcurrent
    /**
     * An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The configuration for the criteria to retry the job.
     */
    val jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = builder.jobExecutionsRetryConfig
    /**
     * Allows you to create a staged rollout of a job.
     */
    val jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * The unique identifier you assigned to this job when it was created.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * Details about the job process.
     */
    val jobProcessDetails: aws.sdk.kotlin.services.iot.model.JobProcessDetails? = builder.jobProcessDetails
    /**
     * The ARN of the job template used to create the job.
     */
    val jobTemplateArn: kotlin.String? = builder.jobTemplateArn
    /**
     * The time, in seconds since the epoch, when the job was last updated.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     *
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
     *
     * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
     *
     * The `namespaceId` feature is in public preview.
     */
    val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * Configuration for pre-signed S3 URLs.
     */
    val presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = builder.presignedUrlConfig
    /**
     * If the job was updated, provides the reason code for the update.
     */
    val reasonCode: kotlin.String? = builder.reasonCode
    /**
     * The status of the job, one of `IN_PROGRESS`, `CANCELED`, `DELETION_IN_PROGRESS` or `COMPLETED`.
     */
    val status: aws.sdk.kotlin.services.iot.model.JobStatus? = builder.status
    /**
     * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a device when the thing representing the device is added to a target group, even after the job was completed by all things originally in the group.
     *
     * We recommend that you use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using continuous jobs, devices that join the group receive the job execution even after the job has been created.
     */
    val targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = builder.targetSelection
    /**
     * A list of IoT things and thing groups to which the job should be sent.
     */
    val targets: List<String>? = builder.targets
    /**
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
     */
    val timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = builder.timeoutConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.Job = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Job(")
        append("abortConfig=$abortConfig,")
        append("comment=$comment,")
        append("completedAt=$completedAt,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("documentParameters=$documentParameters,")
        append("forceCanceled=$forceCanceled,")
        append("isConcurrent=$isConcurrent,")
        append("jobArn=$jobArn,")
        append("jobExecutionsRetryConfig=$jobExecutionsRetryConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("jobId=$jobId,")
        append("jobProcessDetails=$jobProcessDetails,")
        append("jobTemplateArn=$jobTemplateArn,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("namespaceId=$namespaceId,")
        append("presignedUrlConfig=$presignedUrlConfig,")
        append("reasonCode=$reasonCode,")
        append("status=$status,")
        append("targetSelection=$targetSelection,")
        append("targets=$targets,")
        append("timeoutConfig=$timeoutConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (completedAt?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentParameters?.hashCode() ?: 0)
        result = 31 * result + (forceCanceled?.hashCode() ?: 0)
        result = 31 * result + (isConcurrent?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRetryConfig?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobProcessDetails?.hashCode() ?: 0)
        result = 31 * result + (jobTemplateArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (presignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (reasonCode?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetSelection?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Job

        if (abortConfig != other.abortConfig) return false
        if (comment != other.comment) return false
        if (completedAt != other.completedAt) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (documentParameters != other.documentParameters) return false
        if (forceCanceled != other.forceCanceled) return false
        if (isConcurrent != other.isConcurrent) return false
        if (jobArn != other.jobArn) return false
        if (jobExecutionsRetryConfig != other.jobExecutionsRetryConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (jobId != other.jobId) return false
        if (jobProcessDetails != other.jobProcessDetails) return false
        if (jobTemplateArn != other.jobTemplateArn) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (namespaceId != other.namespaceId) return false
        if (presignedUrlConfig != other.presignedUrlConfig) return false
        if (reasonCode != other.reasonCode) return false
        if (status != other.status) return false
        if (targetSelection != other.targetSelection) return false
        if (targets != other.targets) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.Job = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration for criteria to abort the job.
         */
        var abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = null
        /**
         * If the job was updated, describes the reason for the update.
         */
        var comment: kotlin.String? = null
        /**
         * The time, in seconds since the epoch, when the job was completed.
         */
        var completedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in seconds since the epoch, when the job was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A short text description of the job.
         */
        var description: kotlin.String? = null
        /**
         * A key-value map that pairs the patterns that need to be replaced in a managed template job document schema. You can use the description of each key as a guidance to specify the inputs during runtime when creating a job.
         *
         * `documentParameters` can only be used when creating jobs from Amazon Web Services managed templates. This parameter can't be used with custom job templates or to create jobs from them.
         */
        var documentParameters: Map<String, String>? = null
        /**
         * Will be `true` if the job was canceled with the optional `force` parameter set to `true`.
         */
        var forceCanceled: kotlin.Boolean? = null
        var isConcurrent: kotlin.Boolean? = null
        /**
         * An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".
         */
        var jobArn: kotlin.String? = null
        /**
         * The configuration for the criteria to retry the job.
         */
        var jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = null
        /**
         * Allows you to create a staged rollout of a job.
         */
        var jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = null
        /**
         * The unique identifier you assigned to this job when it was created.
         */
        var jobId: kotlin.String? = null
        /**
         * Details about the job process.
         */
        var jobProcessDetails: aws.sdk.kotlin.services.iot.model.JobProcessDetails? = null
        /**
         * The ARN of the job template used to create the job.
         */
        var jobTemplateArn: kotlin.String? = null
        /**
         * The time, in seconds since the epoch, when the job was last updated.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         *
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
         *
         * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
         *
         * The `namespaceId` feature is in public preview.
         */
        var namespaceId: kotlin.String? = null
        /**
         * Configuration for pre-signed S3 URLs.
         */
        var presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = null
        /**
         * If the job was updated, provides the reason code for the update.
         */
        var reasonCode: kotlin.String? = null
        /**
         * The status of the job, one of `IN_PROGRESS`, `CANCELED`, `DELETION_IN_PROGRESS` or `COMPLETED`.
         */
        var status: aws.sdk.kotlin.services.iot.model.JobStatus? = null
        /**
         * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a device when the thing representing the device is added to a target group, even after the job was completed by all things originally in the group.
         *
         * We recommend that you use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using continuous jobs, devices that join the group receive the job execution even after the job has been created.
         */
        var targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = null
        /**
         * A list of IoT things and thing groups to which the job should be sent.
         */
        var targets: List<String>? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT`.
         */
        var timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.Job) : this() {
            this.abortConfig = x.abortConfig
            this.comment = x.comment
            this.completedAt = x.completedAt
            this.createdAt = x.createdAt
            this.description = x.description
            this.documentParameters = x.documentParameters
            this.forceCanceled = x.forceCanceled
            this.isConcurrent = x.isConcurrent
            this.jobArn = x.jobArn
            this.jobExecutionsRetryConfig = x.jobExecutionsRetryConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.jobId = x.jobId
            this.jobProcessDetails = x.jobProcessDetails
            this.jobTemplateArn = x.jobTemplateArn
            this.lastUpdatedAt = x.lastUpdatedAt
            this.namespaceId = x.namespaceId
            this.presignedUrlConfig = x.presignedUrlConfig
            this.reasonCode = x.reasonCode
            this.status = x.status
            this.targetSelection = x.targetSelection
            this.targets = x.targets
            this.timeoutConfig = x.timeoutConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.Job = Job(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AbortConfig] inside the given [block]
         */
        fun abortConfig(block: aws.sdk.kotlin.services.iot.model.AbortConfig.Builder.() -> kotlin.Unit) {
            this.abortConfig = aws.sdk.kotlin.services.iot.model.AbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig] inside the given [block]
         */
        fun jobExecutionsRetryConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRetryConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig] inside the given [block]
         */
        fun jobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobProcessDetails] inside the given [block]
         */
        fun jobProcessDetails(block: aws.sdk.kotlin.services.iot.model.JobProcessDetails.Builder.() -> kotlin.Unit) {
            this.jobProcessDetails = aws.sdk.kotlin.services.iot.model.JobProcessDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PresignedUrlConfig] inside the given [block]
         */
        fun presignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.presignedUrlConfig = aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimeoutConfig] inside the given [block]
         */
        fun timeoutConfig(block: aws.sdk.kotlin.services.iot.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iot.model.TimeoutConfig.invoke(block)
        }
    }
}
