// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action to write to a DynamoDB table.
 *
 * This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.
 */
class DynamoDbV2Action private constructor(builder: Builder) {
    /**
     * Specifies the DynamoDB table to which the message data will be written. For example:
     *
     * `{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }`
     *
     * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     */
    val putItem: aws.sdk.kotlin.services.iot.model.PutItemInput? = builder.putItem
    /**
     * The ARN of the IAM role that grants access to the DynamoDB table.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DynamoDbV2Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DynamoDbV2Action(")
        append("putItem=$putItem,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = putItem?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DynamoDbV2Action

        if (putItem != other.putItem) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DynamoDbV2Action = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the DynamoDB table to which the message data will be written. For example:
         *
         * `{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }`
         *
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         */
        var putItem: aws.sdk.kotlin.services.iot.model.PutItemInput? = null
        /**
         * The ARN of the IAM role that grants access to the DynamoDB table.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DynamoDbV2Action) : this() {
            this.putItem = x.putItem
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DynamoDbV2Action = DynamoDbV2Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PutItemInput] inside the given [block]
         */
        fun putItem(block: aws.sdk.kotlin.services.iot.model.PutItemInput.Builder.() -> kotlin.Unit) {
            this.putItem = aws.sdk.kotlin.services.iot.model.PutItemInput.invoke(block)
        }
    }
}
