// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * A map of key-value pairs containing the patterns that need to be replaced in a managed template job document schema. You can use the description of each key as a guidance to specify the inputs during runtime when creating a job.
 *
 * `documentParameters` can only be used when creating jobs from Amazon Web Services managed templates. This parameter can't be used with custom job templates or to create jobs from them.
 */
class DocumentParameter private constructor(builder: Builder) {
    /**
     * Description of the map field containing the patterns that need to be replaced in a managed template job document schema.
     */
    val description: kotlin.String? = builder.description
    /**
     * An example illustrating a pattern that need to be replaced in a managed template job document schema.
     */
    val example: kotlin.String? = builder.example
    /**
     * Key of the map field containing the patterns that need to be replaced in a managed template job document schema.
     */
    val key: kotlin.String? = builder.key
    /**
     * Specifies whether a pattern that needs to be replaced in a managed template job document schema is optional or required.
     */
    val optional: kotlin.Boolean = builder.optional
    /**
     * A regular expression of the patterns that need to be replaced in a managed template job document schema.
     */
    val regex: kotlin.String? = builder.regex

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DocumentParameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentParameter(")
        append("description=$description,")
        append("example=$example,")
        append("key=$key,")
        append("optional=$optional,")
        append("regex=$regex)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (example?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (optional.hashCode())
        result = 31 * result + (regex?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentParameter

        if (description != other.description) return false
        if (example != other.example) return false
        if (key != other.key) return false
        if (optional != other.optional) return false
        if (regex != other.regex) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DocumentParameter = Builder(this).apply(block).build()

    class Builder {
        /**
         * Description of the map field containing the patterns that need to be replaced in a managed template job document schema.
         */
        var description: kotlin.String? = null
        /**
         * An example illustrating a pattern that need to be replaced in a managed template job document schema.
         */
        var example: kotlin.String? = null
        /**
         * Key of the map field containing the patterns that need to be replaced in a managed template job document schema.
         */
        var key: kotlin.String? = null
        /**
         * Specifies whether a pattern that needs to be replaced in a managed template job document schema is optional or required.
         */
        var optional: kotlin.Boolean = false
        /**
         * A regular expression of the patterns that need to be replaced in a managed template job document schema.
         */
        var regex: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DocumentParameter) : this() {
            this.description = x.description
            this.example = x.example
            this.key = x.key
            this.optional = x.optional
            this.regex = x.regex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DocumentParameter = DocumentParameter(this)
    }
}
