// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class DescribeScheduledAuditResponse private constructor(builder: Builder) {
    /**
     * The day of the month on which the scheduled audit takes place. This is will be `1` through `31` or `LAST`. If days `29`-`31` are specified, and the month does not have that many days, the audit takes place on the `LAST` day of the month.
     */
    val dayOfMonth: kotlin.String? = builder.dayOfMonth
    /**
     * The day of the week on which the scheduled audit takes place, either one of `SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, or `SAT`.
     */
    val dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = builder.dayOfWeek
    /**
     * How often the scheduled audit takes place, either one of `DAILY`, `WEEKLY`, `BIWEEKLY`, or `MONTHLY`. The start time of each audit is determined by the system.
     */
    val frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = builder.frequency
    /**
     * The ARN of the scheduled audit.
     */
    val scheduledAuditArn: kotlin.String? = builder.scheduledAuditArn
    /**
     * The name of the scheduled audit.
     */
    val scheduledAuditName: kotlin.String? = builder.scheduledAuditName
    /**
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
     */
    val targetCheckNames: List<String>? = builder.targetCheckNames

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScheduledAuditResponse(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("frequency=$frequency,")
        append("scheduledAuditArn=$scheduledAuditArn,")
        append("scheduledAuditName=$scheduledAuditName,")
        append("targetCheckNames=$targetCheckNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth?.hashCode() ?: 0
        result = 31 * result + (dayOfWeek?.hashCode() ?: 0)
        result = 31 * result + (frequency?.hashCode() ?: 0)
        result = 31 * result + (scheduledAuditArn?.hashCode() ?: 0)
        result = 31 * result + (scheduledAuditName?.hashCode() ?: 0)
        result = 31 * result + (targetCheckNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeScheduledAuditResponse

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (frequency != other.frequency) return false
        if (scheduledAuditArn != other.scheduledAuditArn) return false
        if (scheduledAuditName != other.scheduledAuditName) return false
        if (targetCheckNames != other.targetCheckNames) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The day of the month on which the scheduled audit takes place. This is will be `1` through `31` or `LAST`. If days `29`-`31` are specified, and the month does not have that many days, the audit takes place on the `LAST` day of the month.
         */
        var dayOfMonth: kotlin.String? = null
        /**
         * The day of the week on which the scheduled audit takes place, either one of `SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, or `SAT`.
         */
        var dayOfWeek: aws.sdk.kotlin.services.iot.model.DayOfWeek? = null
        /**
         * How often the scheduled audit takes place, either one of `DAILY`, `WEEKLY`, `BIWEEKLY`, or `MONTHLY`. The start time of each audit is determined by the system.
         */
        var frequency: aws.sdk.kotlin.services.iot.model.AuditFrequency? = null
        /**
         * The ARN of the scheduled audit.
         */
        var scheduledAuditArn: kotlin.String? = null
        /**
         * The name of the scheduled audit.
         */
        var scheduledAuditName: kotlin.String? = null
        /**
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
         */
        var targetCheckNames: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditResponse) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.frequency = x.frequency
            this.scheduledAuditArn = x.scheduledAuditArn
            this.scheduledAuditName = x.scheduledAuditName
            this.targetCheckNames = x.targetCheckNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DescribeScheduledAuditResponse = DescribeScheduledAuditResponse(this)
    }
}
