// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CreateDynamicThingGroupRequest private constructor(builder: Builder) {
    /**
     * The dynamic thing group index name.
     *
     * Currently one index is supported: `AWS_Things`.
     */
    val indexName: kotlin.String? = builder.indexName
    /**
     * The dynamic thing group search query string.
     *
     * See [Query Syntax](https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html) for information about query string syntax.
     */
    val queryString: kotlin.String? = builder.queryString
    /**
     * The dynamic thing group query version.
     *
     * Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.
     */
    val queryVersion: kotlin.String? = builder.queryVersion
    /**
     * Metadata which can be used to manage the dynamic thing group.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The dynamic thing group name to create.
     */
    val thingGroupName: kotlin.String? = requireNotNull(builder.thingGroupName) { "A non-null value must be provided for thingGroupName" }
    /**
     * The dynamic thing group properties.
     */
    val thingGroupProperties: aws.sdk.kotlin.services.iot.model.ThingGroupProperties? = builder.thingGroupProperties

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDynamicThingGroupRequest(")
        append("indexName=$indexName,")
        append("queryString=$queryString,")
        append("queryVersion=$queryVersion,")
        append("tags=$tags,")
        append("thingGroupName=$thingGroupName,")
        append("thingGroupProperties=$thingGroupProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName?.hashCode() ?: 0
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (queryVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (thingGroupName?.hashCode() ?: 0)
        result = 31 * result + (thingGroupProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDynamicThingGroupRequest

        if (indexName != other.indexName) return false
        if (queryString != other.queryString) return false
        if (queryVersion != other.queryVersion) return false
        if (tags != other.tags) return false
        if (thingGroupName != other.thingGroupName) return false
        if (thingGroupProperties != other.thingGroupProperties) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The dynamic thing group index name.
         *
         * Currently one index is supported: `AWS_Things`.
         */
        var indexName: kotlin.String? = null
        /**
         * The dynamic thing group search query string.
         *
         * See [Query Syntax](https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html) for information about query string syntax.
         */
        var queryString: kotlin.String? = null
        /**
         * The dynamic thing group query version.
         *
         * Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.
         */
        var queryVersion: kotlin.String? = null
        /**
         * Metadata which can be used to manage the dynamic thing group.
         */
        var tags: List<Tag>? = null
        /**
         * The dynamic thing group name to create.
         */
        var thingGroupName: kotlin.String? = null
        /**
         * The dynamic thing group properties.
         */
        var thingGroupProperties: aws.sdk.kotlin.services.iot.model.ThingGroupProperties? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupRequest) : this() {
            this.indexName = x.indexName
            this.queryString = x.queryString
            this.queryVersion = x.queryVersion
            this.tags = x.tags
            this.thingGroupName = x.thingGroupName
            this.thingGroupProperties = x.thingGroupProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupRequest = CreateDynamicThingGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ThingGroupProperties] inside the given [block]
         */
        fun thingGroupProperties(block: aws.sdk.kotlin.services.iot.model.ThingGroupProperties.Builder.() -> kotlin.Unit) {
            this.thingGroupProperties = aws.sdk.kotlin.services.iot.model.ThingGroupProperties.invoke(block)
        }
    }
}
