// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CancelJobRequest private constructor(builder: Builder) {
    /**
     * An optional comment string describing why the job was canceled.
     */
    val comment: kotlin.String? = builder.comment
    /**
     * (Optional) If `true` job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is `false`.
     *
     * Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.
     */
    val force: kotlin.Boolean = builder.force
    /**
     * The unique identifier you assigned to this job when it was created.
     */
    val jobId: kotlin.String? = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * (Optional)A reason code string that explains why the job was canceled.
     */
    val reasonCode: kotlin.String? = builder.reasonCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CancelJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CancelJobRequest(")
        append("comment=$comment,")
        append("force=$force,")
        append("jobId=$jobId,")
        append("reasonCode=$reasonCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (force.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (reasonCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CancelJobRequest

        if (comment != other.comment) return false
        if (force != other.force) return false
        if (jobId != other.jobId) return false
        if (reasonCode != other.reasonCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CancelJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An optional comment string describing why the job was canceled.
         */
        var comment: kotlin.String? = null
        /**
         * (Optional) If `true` job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is `false`.
         *
         * Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.
         */
        var force: kotlin.Boolean = false
        /**
         * The unique identifier you assigned to this job when it was created.
         */
        var jobId: kotlin.String? = null
        /**
         * (Optional)A reason code string that explains why the job was canceled.
         */
        var reasonCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CancelJobRequest) : this() {
            this.comment = x.comment
            this.force = x.force
            this.jobId = x.jobId
            this.reasonCode = x.reasonCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CancelJobRequest = CancelJobRequest(this)
    }
}
