// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for a job rollout.
 */
class AwsJobExponentialRolloutRate private constructor(builder: Builder) {
    /**
     * The minimum number of things that will be notified of a pending job, per minute, at the start of the job rollout. This is the initial rate of the rollout.
     */
    val baseRatePerMinute: kotlin.Int? = builder.baseRatePerMinute
    /**
     * The rate of increase for a job rollout. The number of things notified is multiplied by this factor.
     */
    val incrementFactor: kotlin.Double = builder.incrementFactor
    /**
     * The criteria to initiate the increase in rate of rollout for a job.
     *
     * Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).
     */
    val rateIncreaseCriteria: aws.sdk.kotlin.services.iot.model.AwsJobRateIncreaseCriteria? = builder.rateIncreaseCriteria

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AwsJobExponentialRolloutRate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsJobExponentialRolloutRate(")
        append("baseRatePerMinute=$baseRatePerMinute,")
        append("incrementFactor=$incrementFactor,")
        append("rateIncreaseCriteria=$rateIncreaseCriteria)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseRatePerMinute ?: 0
        result = 31 * result + (incrementFactor.hashCode())
        result = 31 * result + (rateIncreaseCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsJobExponentialRolloutRate

        if (baseRatePerMinute != other.baseRatePerMinute) return false
        if (incrementFactor != other.incrementFactor) return false
        if (rateIncreaseCriteria != other.rateIncreaseCriteria) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AwsJobExponentialRolloutRate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The minimum number of things that will be notified of a pending job, per minute, at the start of the job rollout. This is the initial rate of the rollout.
         */
        var baseRatePerMinute: kotlin.Int? = null
        /**
         * The rate of increase for a job rollout. The number of things notified is multiplied by this factor.
         */
        var incrementFactor: kotlin.Double = 0.0
        /**
         * The criteria to initiate the increase in rate of rollout for a job.
         *
         * Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).
         */
        var rateIncreaseCriteria: aws.sdk.kotlin.services.iot.model.AwsJobRateIncreaseCriteria? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AwsJobExponentialRolloutRate) : this() {
            this.baseRatePerMinute = x.baseRatePerMinute
            this.incrementFactor = x.incrementFactor
            this.rateIncreaseCriteria = x.rateIncreaseCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AwsJobExponentialRolloutRate = AwsJobExponentialRolloutRate(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AwsJobRateIncreaseCriteria] inside the given [block]
         */
        fun rateIncreaseCriteria(block: aws.sdk.kotlin.services.iot.model.AwsJobRateIncreaseCriteria.Builder.() -> kotlin.Unit) {
            this.rateIncreaseCriteria = aws.sdk.kotlin.services.iot.model.AwsJobRateIncreaseCriteria.invoke(block)
        }
    }
}
