// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Filters out specific findings of a Device Defender audit.
 */
class AuditSuppression private constructor(builder: Builder) {
    /**
     * An audit check name. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
     */
    val checkName: kotlin.String? = builder.checkName
    /**
     * The description of the audit suppression.
     */
    val description: kotlin.String? = builder.description
    /**
     * The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to.
     */
    val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * Information that identifies the noncompliant resource.
     */
    val resourceIdentifier: aws.sdk.kotlin.services.iot.model.ResourceIdentifier? = builder.resourceIdentifier
    /**
     * Indicates whether a suppression should exist indefinitely or not.
     */
    val suppressIndefinitely: kotlin.Boolean? = builder.suppressIndefinitely

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AuditSuppression = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuditSuppression(")
        append("checkName=$checkName,")
        append("description=$description,")
        append("expirationDate=$expirationDate,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("suppressIndefinitely=$suppressIndefinitely)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (suppressIndefinitely?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuditSuppression

        if (checkName != other.checkName) return false
        if (description != other.description) return false
        if (expirationDate != other.expirationDate) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (suppressIndefinitely != other.suppressIndefinitely) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AuditSuppression = Builder(this).apply(block).build()

    class Builder {
        /**
         * An audit check name. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
         */
        var checkName: kotlin.String? = null
        /**
         * The description of the audit suppression.
         */
        var description: kotlin.String? = null
        /**
         * The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to.
         */
        var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information that identifies the noncompliant resource.
         */
        var resourceIdentifier: aws.sdk.kotlin.services.iot.model.ResourceIdentifier? = null
        /**
         * Indicates whether a suppression should exist indefinitely or not.
         */
        var suppressIndefinitely: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AuditSuppression) : this() {
            this.checkName = x.checkName
            this.description = x.description
            this.expirationDate = x.expirationDate
            this.resourceIdentifier = x.resourceIdentifier
            this.suppressIndefinitely = x.suppressIndefinitely
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AuditSuppression = AuditSuppression(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ResourceIdentifier] inside the given [block]
         */
        fun resourceIdentifier(block: aws.sdk.kotlin.services.iot.model.ResourceIdentifier.Builder.() -> kotlin.Unit) {
            this.resourceIdentifier = aws.sdk.kotlin.services.iot.model.ResourceIdentifier.invoke(block)
        }
    }
}
