// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Information about the audit check.
 */
class AuditCheckDetails private constructor(builder: Builder) {
    /**
     * True if the check is complete and found all resources compliant.
     */
    val checkCompliant: kotlin.Boolean? = builder.checkCompliant
    /**
     * The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     */
    val checkRunStatus: aws.sdk.kotlin.services.iot.model.AuditCheckRunStatus? = builder.checkRunStatus
    /**
     * The code of any error encountered when this check is performed during this audit. One of "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
     */
    val errorCode: kotlin.String? = builder.errorCode
    /**
     * The message associated with any error encountered when this check is performed during this audit.
     */
    val message: kotlin.String? = builder.message
    /**
     * The number of resources that were found noncompliant during the check.
     */
    val nonCompliantResourcesCount: kotlin.Long? = builder.nonCompliantResourcesCount
    /**
     * Describes how many of the non-compliant resources created during the evaluation of an audit check were marked as suppressed.
     */
    val suppressedNonCompliantResourcesCount: kotlin.Long? = builder.suppressedNonCompliantResourcesCount
    /**
     * The number of resources on which the check was performed.
     */
    val totalResourcesCount: kotlin.Long? = builder.totalResourcesCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AuditCheckDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuditCheckDetails(")
        append("checkCompliant=$checkCompliant,")
        append("checkRunStatus=$checkRunStatus,")
        append("errorCode=$errorCode,")
        append("message=$message,")
        append("nonCompliantResourcesCount=$nonCompliantResourcesCount,")
        append("suppressedNonCompliantResourcesCount=$suppressedNonCompliantResourcesCount,")
        append("totalResourcesCount=$totalResourcesCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkCompliant?.hashCode() ?: 0
        result = 31 * result + (checkRunStatus?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (nonCompliantResourcesCount?.hashCode() ?: 0)
        result = 31 * result + (suppressedNonCompliantResourcesCount?.hashCode() ?: 0)
        result = 31 * result + (totalResourcesCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuditCheckDetails

        if (checkCompliant != other.checkCompliant) return false
        if (checkRunStatus != other.checkRunStatus) return false
        if (errorCode != other.errorCode) return false
        if (message != other.message) return false
        if (nonCompliantResourcesCount != other.nonCompliantResourcesCount) return false
        if (suppressedNonCompliantResourcesCount != other.suppressedNonCompliantResourcesCount) return false
        if (totalResourcesCount != other.totalResourcesCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AuditCheckDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * True if the check is complete and found all resources compliant.
         */
        var checkCompliant: kotlin.Boolean? = null
        /**
         * The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         */
        var checkRunStatus: aws.sdk.kotlin.services.iot.model.AuditCheckRunStatus? = null
        /**
         * The code of any error encountered when this check is performed during this audit. One of "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
         */
        var errorCode: kotlin.String? = null
        /**
         * The message associated with any error encountered when this check is performed during this audit.
         */
        var message: kotlin.String? = null
        /**
         * The number of resources that were found noncompliant during the check.
         */
        var nonCompliantResourcesCount: kotlin.Long? = null
        /**
         * Describes how many of the non-compliant resources created during the evaluation of an audit check were marked as suppressed.
         */
        var suppressedNonCompliantResourcesCount: kotlin.Long? = null
        /**
         * The number of resources on which the check was performed.
         */
        var totalResourcesCount: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AuditCheckDetails) : this() {
            this.checkCompliant = x.checkCompliant
            this.checkRunStatus = x.checkRunStatus
            this.errorCode = x.errorCode
            this.message = x.message
            this.nonCompliantResourcesCount = x.nonCompliantResourcesCount
            this.suppressedNonCompliantResourcesCount = x.suppressedNonCompliantResourcesCount
            this.totalResourcesCount = x.totalResourcesCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AuditCheckDetails = AuditCheckDetails(this)
    }
}
