// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.serde

import aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig
import aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery
import aws.sdk.kotlin.services.internetmonitor.model.MonitorConfigState
import aws.sdk.kotlin.services.internetmonitor.model.UpdateMonitorRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateMonitorOperationSerializer: HttpSerialize<UpdateMonitorRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateMonitorRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.monitorName) { "monitorName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20210603"))
                add(PercentEncoding.Path.encode("Monitors"))
                add(PercentEncoding.SmithyLabel.encode("${input.monitorName}"))
            }
        }

        val payload = serializeUpdateMonitorOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateMonitorOperationBody(context: ExecutionContext, input: UpdateMonitorRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val HEALTHEVENTSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HealthEventsConfig"))
    val INTERNETMEASUREMENTSLOGDELIVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InternetMeasurementsLogDelivery"))
    val MAXCITYNETWORKSTOMONITOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxCityNetworksToMonitor"))
    val RESOURCESTOADD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourcesToAdd"))
    val RESOURCESTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourcesToRemove"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TRAFFICPERCENTAGETOMONITOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TrafficPercentageToMonitor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(HEALTHEVENTSCONFIG_DESCRIPTOR)
        field(INTERNETMEASUREMENTSLOGDELIVERY_DESCRIPTOR)
        field(MAXCITYNETWORKSTOMONITOR_DESCRIPTOR)
        field(RESOURCESTOADD_DESCRIPTOR)
        field(RESOURCESTOREMOVE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRAFFICPERCENTAGETOMONITOR_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.healthEventsConfig?.let { field(HEALTHEVENTSCONFIG_DESCRIPTOR, it, ::serializeHealthEventsConfigDocument) }
        input.internetMeasurementsLogDelivery?.let { field(INTERNETMEASUREMENTSLOGDELIVERY_DESCRIPTOR, it, ::serializeInternetMeasurementsLogDeliveryDocument) }
        input.maxCityNetworksToMonitor?.let { field(MAXCITYNETWORKSTOMONITOR_DESCRIPTOR, it) }
        if (input.resourcesToAdd != null) {
            listField(RESOURCESTOADD_DESCRIPTOR) {
                for (el0 in input.resourcesToAdd) {
                    serializeString(el0)
                }
            }
        }
        if (input.resourcesToRemove != null) {
            listField(RESOURCESTOREMOVE_DESCRIPTOR) {
                for (el0 in input.resourcesToRemove) {
                    serializeString(el0)
                }
            }
        }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        input.trafficPercentageToMonitor?.let { field(TRAFFICPERCENTAGETOMONITOR_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
