// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.serde

import aws.sdk.kotlin.services.internetmonitor.model.FilterParameter
import aws.sdk.kotlin.services.internetmonitor.model.QueryType
import aws.sdk.kotlin.services.internetmonitor.model.StartQueryRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartQueryOperationSerializer: HttpSerialize<StartQueryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartQueryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.monitorName) { "monitorName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20210603"))
                add(PercentEncoding.Path.encode("Monitors"))
                add(PercentEncoding.SmithyLabel.encode("${input.monitorName}"))
                add(PercentEncoding.Path.encode("Queries"))
            }
        }

        val payload = serializeStartQueryOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartQueryOperationBody(context: ExecutionContext, input: StartQueryRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val FILTERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FilterParameters"))
    val QUERYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryType"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(FILTERPARAMETERS_DESCRIPTOR)
        field(QUERYTYPE_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.filterParameters != null) {
            listField(FILTERPARAMETERS_DESCRIPTOR) {
                for (el0 in input.filterParameters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFilterParameterDocument))
                }
            }
        }
        input.queryType?.let { field(QUERYTYPE_DESCRIPTOR, it.value) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
    }
    return serializer.toByteArray()
}
